package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/29
 */
@Data
public class BiddingConformityListDto extends BaseDomainDto implements Serializable {
    /**
     * 审查小组成员memberId(当前登录用户)
     */
    private String biddingGroupMemberId;
    /**
     * 需求编号
     */
    private String demandCode;
    /**
     * 商品描述.
     */
    private String goodsDesription;
    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 要求到货日期.
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date dateRequiredDelivery;
    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;
    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;
    /**
     * 需求地址具体化
     */
    private List<String> demandAddressNumDtos;
    /**
     * 需求地址
     */
    private List<String> demandAddrList;
    /**
     * 符合性个数
     */
    private Integer conformityNum;
    /**
     * 响应供应商数
     */
    private Integer demandResponNum;

    /**
     * 已审查供应商数
     */
    private Integer providersAudited;


}
