package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 符合性审查审核-页面数据封装 DTO
 *
 * @author Drury
 * @date 2018/3/20
 */
@Data
public class BiddingConformityReviewInfoDTO implements Serializable {

    /**
     * 供应商 ID
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 符合性审查供应商响应审核状态 (符合, 不符合)
     */
    private String supplierResponseAuditStatus;

    /**
     * 商品描述 (竞价需求)
     */
    private String goodsDescription;

    /**
     * 规格参数 (竞价需求)
     */
    private String specification;

    /**
     * 服务要求 (竞价需求)
     */
    private String serviceRequirement;

    /**
     * 要求到货日期 (竞价需求)
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateRequiredDelivery;

    /**
     * 商品描述 (竞价响应)
     */
    private String goodsTitle;

    /**
     * 规格参数 (竞价响应)
     */
    private String goodsParams;

    /**
     * 服务承诺 (竞价响应)
     */
    private String serverPromise;

    /**
     * sku (竞价响应)
     */
    private String sku;

    /**
     * 商品链接 (竞价响应)
     */
    private String goodsLink;

    // TODO 附件待陈圣融确认
    /**
     * 附件 (竞价响应)
     */
    private List<String> attachments;

    /**
     * 报价有效期 (竞价响应)
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date pricePeriodOfValidity;

    /**
     * 供货周期 (竞价响应)
     */
    private BigDecimal supplyPeriod;

    /**
     * 备注 (竞价响应)
     */
    private String remark;

    /**
     * 竞价数量及地址
     */
    private List<BiddingConformityReviewDemandAddDTO> demandAdds;

    /**
     * 符合性审查
     */
    private List<BiddingConformityReviewDTO> conformityReviews;

}
