package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月16日16:23:25
 */
@Data
public class BiddingDemandQueryDto implements Serializable {

    /**
     * 需求编号.
     */
    private String demandCode;

    /**
     * 商品描述.
     */
    private String goodsDesription;

    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 要求到货日期.
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date dateRequiredDelivery;

    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;

    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;

    /**
     * 需求地址
     */
    private String demandAddress;


    /**
     * 符合性审查（个）
     */
    private Integer complianceAuditNum;


    /**
     * 竞价需求符合性列表
     */

    private List<JcbdBiddingConformanceDto> jcbdBiddingConformances;

    /**
     * 竞价需求地址列表
     */

    private List<JcbdDemandAddressNumDto> jcbdDemandAddressNums;

}
