package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created on 2018/3/27.
 *
 * @author junyang.dong
 */
@Data
public class BiddingDemandResDto implements Serializable {

    /**
     * 商品描述.
     */
    private String goodsDesription;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 服务参数.
     */
    private String serviceRequirement;


    /**
     * 要求到货日期.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateRequiredDelivery;


    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 商品规格.
     */
    private String goodsParams;

    /**
     * 服务承诺.
     */
    private String serverPromise;


    /**
     * sku.
     */
    private String sku;

    /**
     * 商品链接.
     */
    private String goodsLink;

    /**
     * 附件
     */
    private List<MallAttachmentDto> attachment;

    /**
     * 供货周期.
     */
    private BigDecimal supplyPeriod;

    /**
     * 报价有效期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date qouteIndate;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 供应商需求地址商品数量满足性响应列表
     */

    //private List<BiddingDemandAddressResDto> jcbdProviderAddressResponses;


    /**
     * 供应商符合性响应列表
     */

    //private List<JcbdProviderAccordResDto> jcbdProviderConformanceResps;

}
