package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
/**
* @author luoxianwei
* @date 2018/4/14 
*/
@Data
public class BiddingOrderMangerDto implements Serializable{

    /**
     * 订单id
     */
    private String id;

    /**
     *竞价编号
     */
    private String biddingCode;

    /**
     * 订单号.
     */
    private String orderNo;

    /**
     * 下单时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateCreated;

    /**
     * 商品项数
     */
    private BigDecimal goodsNumber;

    /**
     * 下单金额
     */
    private BigDecimal singleAmount;

    /**
     * 确认时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confirmOrderTime;

    /**
     *  状态
     */
    private String status;
    /**
     * 状态中文
     */
    private String statusDescription;

    /**
     * 操作
     */
    private List<JcbdRoleOperationDto> operation;

}
