package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* @author luoxianwei
* @date 2018/4/14
*/
@Data
public class BiddingOrderResultDto implements Serializable{

    /**
     * 订单id
     */
    private String id;

    /**
     * 竞价编号
     */
    private String biddingCode;
    /**
     *执行采购编号
     */
    private String purchaseNo;

    /**
     * 订单号.
     */
    private String orderNo;

    /**
     * 下单时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateCreated;

    /**
     * 商品项数
     */
    private BigDecimal goodsNumber;

    /**
     * 下单金额
     */
    private BigDecimal singleAmount;

    /**
     * 确认时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confirmationTime;

    /**
     *  状态
     */
    private String status;
    /**
     * 添加状态描述
     */
    private String statusDescription;

    /**
     * 操作
     */
    private List<JcbdRoleOperationDto> operation;
}
