package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 陈圣融
 * @date 2018-03-16
 **/
@Data
public class BiddingResponseDemandOutlineDto implements Serializable {
    /**
     * 需求id
     */
    private String demandId;
    /**
     * 需求编号
     */
    private String demandNo;
    /**
     * 商品描述
     */
    private String goodsDesription;
    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;
    /**
     * 规格参数.
     */
    private String specification;
    /**
     * 要求到货日期
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date requiredDeliveryDate;
    /**
     * 最低采购数量
     */
    private Long lowestPurchaseNumber;
    /**
     * 最高采购数量
     */
    private Long highestPurchaseNumber;
    /**
     * 竞价需求响应状态
     */
    private String demandResponseStatus;
    /**
     * 需求地址
     */
    private String demandAddress;
    /**
     * 报价.
     */
    private BigDecimal price;
    /**
     * 符合性审查数
     */
    private Integer conformanceNumber;
    /**
     * 响应供应商数
     */
    private Integer responseSupplierNumber;
}
