package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wangtao
 * @version 2018年4月3日21:37:51，竞价结果页面已成交供应商需求响应列表
 */
@Data
public class BiddingResultDemandQueryDto implements Serializable {


    /**
     * 需求编号
     */
    private String demandCode;

    /**
     * 响应供应商id (竞价供应商表主键)
     */
    private String responseProviderId;

    /**
     * 供应商名称
     */
    private String responseProviderName;

    /**
     * 商品标题
     */
    private String goodsTitle;

    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 商品规格.
     */
    private String goodsParams;

    /**
     * 服务承诺.
     */
    private String servicePromise;


    /**
     * sku.
     */
    private String sku;

    /**
     * 是否修改过sku
     */
    private Boolean skuIsModify;

    /**
     * 商品链接.
     */
    private String goodsLink;

    /**
     * 价格.
     */
    private BigDecimal price;

    /**
     * 报价有效期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date qouteIndate;

    /**
     * 供货周期.
     */
    private BigDecimal supplyPeriod;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 是否满足全部条件 0-不满足 1-满足
     */
    private String isAllAccord;


}
