package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import utils.excel.excelcreate.annotation.ColumnName;
import utils.excel.excelcreate.annotation.Excel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* @author luoxianwei
* @date 2018/4/14 
*/
@Data
@Excel(sheetNames = {"sheet one"})
public class BiddingSupplierOrderMangerDto implements Serializable{

    /**
     * 订单id
     */

    private String id;
    /**
     *竞价编号
     */
    @ColumnName(column = "竞价编号")
    private String biddingCode;

    /**
     * 订单号
     */
    @ColumnName(column = "订单号")
    private String orderNo;

    /**
     * 下单日期
     */
    @ColumnName(column = "下单日期")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateCreated;

    /**
     * 地址
     */
    @ColumnName(column = "地址")
    private String address;

    /**
     * 商品编码
     */
    @ColumnName(column = "商品编码")
    private  String goodsCode;

    /**
     * 商品项数
     */
    @ColumnName(column = "商品项数")
    private Integer goodsNumber;

    /**
     * 下单金额
     */
    @ColumnName(column = "下单金额")
    private BigDecimal singleAmount;

    /**
     *  状态
     */
    private String supplierOrderStatus;
    /**
     * 状态中文
     */
    @ColumnName(column = "状态")
    private String supplierOrderStatusDescription;

    /**
     * 操作
     */
    private List<JcbdRoleOperationDto> operation;

}
