package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBdProviderDto extends BaseDomainDto implements Serializable {

    /**
     * 主键.
     */
    private String id;

    /**
     * 供应商id.storeId
     */
    private String providerId;

    /**
     * 关联竞价id.
     */

    private JcbdBiddingDto jcbdBidding;

    /**
     * 供应商竞价状态.
     */
    private String status;
    /**
     * 响应状态
     */
    private String responseStatus;
    /**
     * 成交状态
     */
    private String dealStatus;
    /**
     * 符合性审查状态
     */
    private String conformanceCheckStatus;

    /**
     * 响应供应商联系人id.
     */
    private String contactsId;

    /**
     * 供应商名称
     */
    private String providerName;

    /**
     * 报价有效期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date offerValidity;

    /**
     * 是否已发布
     */
    private Boolean publish;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public JcbdBiddingDto getJcbdBidding() {
        return jcbdBidding;
    }

    public void setJcbdBidding(JcbdBiddingDto jcbdBidding) {
        this.jcbdBidding = jcbdBidding;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContactsId() {
        return contactsId;
    }

    public void setContactsId(String contactsId) {
        this.contactsId = contactsId;
    }

    public String getProviderName() {
        return providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }
}
