package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBiddingDemandDto extends BaseDomainDto implements Serializable{
    /**
     * 主键.
     */

    private String id;

    /**
     * 需求编号.
     */
    private String demandCode;

    /**
     * 商品描述.
     */
    private String goodsDesription;

    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 服务参数.
     */
    private String serviceRequirement;


    /**
     * 要求到货日期.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date dateRequiredDelivery;

    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;

    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;


    /**
     * 已购买数量.
     */
    private Integer purchaseNum;

    /**
     * 关联竞价id.
     */
    private String biddingId;
    /**
     * 关键竞价编号
     */
    private String biddingCode;

    /**
     * 竞价
     */
    private JcbdBiddingDto jcbdBidding;
    /**
     * 竞价需求符合性列表
     */
    private List<JcbdBiddingConformanceDto> jcbdBiddingConformances;

    /**
     * 竞价供应商需求响应列表
     */
    private List<JcbdBiddingDemandResponseDto> jcbdBiddingDemandResponses;

    /**
     * 竞价购买记录例表
     */
    private List<JcbdBiddingPurchaseLogDto> jcbdBiddingPurchaseLogs;

    /**
     * 竞价需求地址列表
     */

    private List<JcbdDemandAddressNumDto> jcbdDemandAddressNums;


}
