package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBiddingDemandResponseDto extends BaseDomainDto implements Serializable {
    /**
     * 主键.
     */
    private String id;

    /**
     * 竞价需求id.
     */

    private JcbdBiddingDemandDto jcbdBiddingDemand;

    /**
     * 响应供应商id (竞价供应商表主键).
     */
    private String responseProviderId;
    /**
     * 供应商名字
     */
    private String providerName;
    /**
     * 商品标题
     */
    private String goodsTitle;
    /**
     * 品牌.
     */
    private String goodsBrand;

    /**
     * 型号
     */
    private String goodsModel;
    /**
     * 商品规格.
     */
    private String goodsParams;

    /**
     * 服务承诺.(失效)
     */
    private String serverPromise;

    /**
     * 服务承诺.
     */
    private String servicePromise;


    /**
     * sku.
     */
    private String sku;
    /**
     * sku是否修改
     */
    private Boolean skuModify;

    /**
     * 商品链接.
     */
    private String goodsLink;

    /**
     * 附件
     */
    private List<MallAttachmentDto> attachment;

    /**
     * 报价有效期
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date offerValidity;

    /**
     * 价格.
     */
    private BigDecimal price;

    /**
     * 供货周期.
     */
    private BigDecimal supplyPeriod;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 是否满足全部条件 0-不满足 1-满足
     */
    private String isAllAccord;

    /**
     * 供应商需求地址商品数量满足性响应列表
     */

    private List<JcbdProviderAddressResponseDto> jcbdProviderAddressResponses;


    /**
     * 供应商符合性响应列表
     */

    private List<JcbdProviderConformanceRespDto> jcbdProviderConformanceResps;

    /**
     * 已审核且状态
     */
    private String auditedAndStatus;

    /**
     * storeId
     */
    private String storeId;


}
