package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBiddingDto extends BaseDomainDto implements Serializable {
    /**
     * 主键.
     */
    private String id;

    /**
     * 竞价编号.
     */
    private String biddingCode;

    /**
     * 竞价描述.
     */
    private String biddingDescription;

    /**
     * 竞价开始响应时间.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date timeStartResponse;

    /**
     * 竞价截止响应时间.
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date timeEndResponse;

    /**
     * 竞价周期.
     */
    private Integer biddingPeriod;


    /**
     * 邀请供应商数.
     */
    private Integer providerInviteNum;

    /**
     * 响应供应商数.
     */
    private Integer providerResponseNum;

    /**
     * 竞价状态.
     */
    private String status;

    /**
     * 确认竞价结果方式.
     */
    private BigDecimal wayForConfirmBiddingResult;

    /**
     * 经办人id.
     */
    private String operatorId;
    /**
     * 经办人姓名
     */
    private String operatorName;
    /**
     * 经办人手机号
     */
    private String operatorPhone;
    /**
     * 备注.
     */
    private String remark;
    /**
     * 竞价提交审核备注
     */
    private String bdCommitContent;
    /**
     * 竞价小组审核编号.
     */
    private String groupCheckNo;

    /**
     * 符合性审查编号.
     */
    private String conformanceNo;


    /**
     * 投票编号.
     */
    private String voteNo;


    /**
     * 竞价竞价小组审核意见列表
     */

    private List<JcbdBdGroupCheckDto> jcbdBdGroupChecks;

    /**
     * 竞价供应商列表
     */

    private List<JcbdBdProviderDto> jcbdBdProviders;


    /**
     * 竞价需求列表
     */
    private List<JcbdBiddingDemandDto> jcbdBiddingDemands;

    /**
     * 竞价小组成员列表
     */

    private List<JcbdBiddingGroupMemberDto> jcbdBiddingGroupMembers;

    /**
     * 竞价操作记录列表
     */

    private List<JcbdBiddingOperationLogDto> jcbdBiddingOperationLogs;


    /**
     * 竞价采购订单列表
     */

    private List<JcbdOrderDto> jcbdOrders;
}
