package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBiddingQueryDto implements Serializable{
    /**
     * 当前用户id.
     */
    private String userId;

    /**
     * 当前用户email
     */
    private String email;
    /**
     * 供应商在我们store库id
     */
    private String providerId;
    /**
     * 当前用户所拥有的竞价角色
     */
    private List<String> roles;
    /**
     * 竞价编号
     */
    private String jcbdBiddingNo;
    /**
     * 竞价描述
     */
    private String describe;
    /**
     * 竞价开始时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date startTime;
    /**
     * 竞价开始时间(供应商查询使用)
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date startTime2;
    /**
     * 竞价结束时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime;
    /**
     * 竞价结束时间（供应商查询使用）
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime2;
    /**
     * 竞价状态
     */
    private List<String> states;
    /**
     * 分页参数
     */
    private Pageable pageable;

}
