package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdBiddingQueryResultDto implements Serializable{
    /**
     * 竞价编号
     */
    private String jcbdBiddingNo;
    /**
     * 竞价描述
     */
    private String describe;
    /**
     * 竞价响应开始时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date startTime;
    /**
     * 竞价响应截止时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date endTime;
    /**
     * 邀请供应商数
     */
    private Integer invitationSupplierNum;
    /**
     * 响应供应商数
     */
    private Integer responseSupplierNum;
    /**
     * 需求数量
     */
    private Integer needNum;
    /**
     * 状态
     */
    private String state;

    /**
     * 状态名
     */
    private String stateName;

    /**
     * 可用操作
     */
    private List<JcbdRoleOperationDto> operations;
}
