package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdMallOrderDto extends BaseDomainDto implements Serializable {

    /**
     * 主键.
     */

    private String id;

    /**
     * 竞价id.
     */
   // private JcbdOrderDto jcbdOrder;
    private String jdbdOrderId;

    /**
     * 订单号.
     */
    private String orderNo;

    /**
     * 竞价订单状态
     */
    private String status;
    /**
     * 订单地址
     */
    private String address;

    /**
     * 确认订单时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confirmOrderTime;
    /**
     * 竞价供应商id
     */
    private String providerId;
    /**
     * 供应商订单状态
     */
    private String supplierOrderStatus;

    List<JcbdBiddingOrderItemDto> jcbdBiddingOrderItems;
}
