package dto;

import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdOrderDto extends BaseDomainDto implements Serializable {
    /**
     * 主键.
     */
    private String id;
    /**
     * 竞价id.
     */
    private JcbdBiddingDto jcbdBidding;
    /**
     * 竞价订单号.
     */
    private String bdOrderNo;
    /**
     * 竞价订单状态.
     */
    private String status;
    /**
     * 运费
     */
    private BigDecimal freight;
    /**
     * 商品金额
     */
    private String goodsPrice;
    /**
     * 订单用途
     */
    private String orderUse;
    /**
     * 下单机构
     */
    private String companyName;
    /**
     * 订单类型
     */
    private String orderType;
    /**
     * 支付方式
     */
    private String payType;
    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商id
     */
    private String supplierId;

    /**
     * 订单总金额
     */
    private BigDecimal totalMoney;
    /**
     * 竞价采购实物商城订单列表
     */
    private List<JcbdMallOrderDto> jcbdMallOrders;
    /**
     * 备注
     */
    private String remark;

    /**
     * 采购编号
     */
    private  String purchaseNo;

}
