package dto;

import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdProviderAddressResponseDto extends BaseDomainDto implements Serializable{
    /**
     * 主键.
     */

    private String id;

    /**
     * 竞价需求响应id.
     */
    private JcbdBiddingDemandResponseDto jcbdBiddingDemandResponse;

    /**
     * 需求地址id.
     */
    private String demandAddressId;

    /**
     * 省名称/最低采购数量/最高采购数量
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 需求数量.
     */
    private Long numberNeed;

    /**
     * 最低采购数量/最高采购数量/地区全称
     */
    private String content;

    /**
     * 满足状态.1:满足，0：不满足
     */
    private String status;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 页面显示位置.
     */
    private Integer displayIndex;

}
