package dto;

import lombok.Data;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

/**
 * @author bande
 * @date 2018/3/15
 */
@Data
public class JcbdProviderConformanceRespDto extends BaseDomainDto implements Serializable {

    public static final String CONFORMANCE_STATUS_YES_NUM = "1";
    public static final String CONFORMANCE_STATUS_NO_NUM = "0";
    public static final String CONFORMANCE_STATUS_YES_DESC= "符合";
    public static final String CONFORMANCE_STATUS_NO_DESC = "不符合";

    /**
     * 主键.
     */

    private String id;

    /**
     * 竞价需求响应id.
     */
    private JcbdBiddingDemandResponseDto jcbdBiddingDemandResponse;

    /**
     * 竞价需求符合性id.
     */
    private String biddingConformanceId;

    /**
     * 符合性内容.
     */
    private String conformance;

    /**
     * 供应商响应符合状态.0-不满足 1-满足
     */
    private String status;
    /**
     * 符合性审查项符合状态 1-符合 0-不符合
     */
    private String conformanceStatus;

    /**
     * 备注.
     */
    private String remark;

    /**
     * 不通过的小组成员str
     */
    private String notPassMemberStr;

}
