package dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author bande
 * @date 2018/4/2
 */
@Data
public class JcbdTempOrderDto implements Serializable{
    /**
     * 主键.
     */
    private String id;

    /**
     * 竞价编号
     */
    private String biddingNo;

    /**
     * 收件人地址id（memberAddress表主键）
     */
    private String memberAddressId;

    /**
     * 商品sku集合
     */
    private List<JcbdTempGoodsDto> jcbdTempGoodses;

    /**
     * 发票类型 1.增值税专用发票 2.增值税普通发票
     */
    private String invoiceType;

    /**
     * 开票机构
     */
    private String invoiceOrganization;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 公司地址及电话
     */
    private String companyAddressAndPhone;
    /**
     * 开户行及账号
     */
    private String bankAndAccount;

    /**
     * 纳税人识别号
     */
    private String taxIdentification;

    /**
     * 发票收件人
     */
    private String consigneeName;
    /**
     * 发票收件人电话
     */
    private String consigneePhone;
    /**
     * 发票收件人省
     */
    private String consigneeProvinceCode;

    /**
     * 发票收件人市
     */
    private String consigneeCityCode;
    /**
     * 详细地址
     */
    private String addressDetail;
//    /**
//     * 收货地址Code码
//     */
//    private String memberAddressCode;
//    /**
//     * 收货地址详细地址
//     */
//    private String memberAddressDetail;
//    /**
//     * 发票收件地址码
//     */
//    private String invoiceAddressCode;

    /**
     * storeId
     */
    private String storeId;

    /**
     * 发票收件地址是否同收件人地址:1是0否
     */
    private String consigneeFlag;

    /**
     * 发票机构companyId
     */
    private String companyId;

}
