package dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 比价页比价信息
 * Created on 2018/3/30.
 *
 * @author junyang.dong
 */
@Data
public class PriceParityInfoDto implements Serializable {
    /**
     * 供应商
     */
    private String supllierName;

    /**
     * 供应商状态
     */
    private String supplierStatus;
    /**
     * 需求编号
     */
    private String demandNo;
    /**
     * 最低采购数量
     */
    private Long lowestPurchaseNumber;
    /**
     * 单价
     */
    private BigDecimal price;
    /**
     * 总价
     */
    private BigDecimal totalPrice;

    /**
     * 合计
     */
    private BigDecimal summation;

    /**
     * 供应商id
     */
    private String providerId;

}
