package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 供应商竞价响应
 * Created by xiaoxu on 2018/3/23.
 */
@Data
public class SuppBiddingResponseDto implements Serializable {

    /**
     * 需求编号
     */
    private String demandCode;

    /**
     * 商品描述.
     */
    private String goodsDesription;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 要求到货日期.
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date dateRequiredDelivery;

    /**
     * 最低采购数量.
     */
    private Long minPurchaseAmount;

    /**
     * 最高采购数量.
     */
    private Long maxPurchaseAmount;

    /**
     * 竞价需求地址列表
     */
    private List<JcbdDemandAddressNumDto> jcbdDemandAddressNums;

    /**
     * 符合性审查（个）
     */
    private Integer complianceAuditNum;

    /**
     * 响应供应商数量
     */
    private Integer demandResponseCount;

    public String getDemandCode() {
        return demandCode;
    }

    public void setDemandCode(String demandCode) {
        this.demandCode = demandCode;
    }

    public String getGoodsDesription() {
        return goodsDesription;
    }

    public void setGoodsDesription(String goodsDesription) {
        this.goodsDesription = goodsDesription;
    }

    public Date getDateRequiredDelivery() {
        return dateRequiredDelivery;
    }

    public void setDateRequiredDelivery(Date dateRequiredDelivery) {
        this.dateRequiredDelivery = dateRequiredDelivery;
    }

    public Long getMinPurchaseAmount() {
        return minPurchaseAmount;
    }

    public void setMinPurchaseAmount(Long minPurchaseAmount) {
        this.minPurchaseAmount = minPurchaseAmount;
    }

    public Long getMaxPurchaseAmount() {
        return maxPurchaseAmount;
    }

    public void setMaxPurchaseAmount(Long maxPurchaseAmount) {
        this.maxPurchaseAmount = maxPurchaseAmount;
    }

    public List<JcbdDemandAddressNumDto> getJcbdDemandAddressNums() {
        return jcbdDemandAddressNums;
    }

    public void setJcbdDemandAddressNums(List<JcbdDemandAddressNumDto> jcbdDemandAddressNums) {
        this.jcbdDemandAddressNums = jcbdDemandAddressNums;
    }

    public Integer getComplianceAuditNum() {
        return complianceAuditNum;
    }

    public void setComplianceAuditNum(Integer complianceAuditNum) {
        this.complianceAuditNum = complianceAuditNum;
    }

    public Integer getDemandResponseCount() {
        return demandResponseCount;
    }

    public void setDemandResponseCount(Integer demandResponseCount) {
        this.demandResponseCount = demandResponseCount;
    }
}
