package dto;

import lombok.Data;

import java.io.Serializable;

/**
 * 采购信息Dto
 * @author JIAN
 * @Date 2018/3/15
 */
@Data
public class TempJcbdOrderDto implements Serializable{

    /**
     * 商品
     */
    JcbdBiddingDemandResponseDto demandResponse;
    /**
     * 购买数量
     */
    Integer count;
    /**
     * 收件人信息
     */
    String memberAddrId;

    //发票信息部分
    /**
     * 发票类型 01 增值税 02 普通
     */
    private String invoiceType;
    /**
     *  开票机构ID，可以带出其他增值税信息
     */
    private String companyId;
    /**
     * 发票抬头
     */
    private String invoiceName;
    /**
     * 纳税人识别号
     */
    private String invoiceCode;

    /**
     * 是否同收件人
     */
    private boolean sameAsAchiever;
    /**
     *   收件人姓名
     */
    private String name;
    /**
     *     联系电话
     */
    private String phone;
    /**
     *     详细地址
     */
    private String address;
    /**
     * 省份代码
     */
    private String provinceCode;
    /**
     * 城市代码
     */
    private String cityCode;



}
