package query;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
* @author luoxianwei
* @date 2018/4/14
 * 订单管理查询条件
*/
@Data
public class BiddingOrderManagerListQuery implements Serializable {

    /**
     * 竞价编号
     */
    private String biddingCode;
    /**
     * 下单开始时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date orderStartTime;
    /**
     * 下单结束时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date orderEndTime;
    /**
     * 状态
     */
    private String status;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 确认开始时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confStartTime;
    /**
     * 确认结束时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confEndTime;
    /**
     * 经办人id
     */
    private String memeberId;

}
