package query;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* @author luoxianwei
* @date 2018/4/14
 * 供应商订单管理查询条件
*/
@Data
public class BiddingSupplierOrderManagerListQuery implements Serializable {

    /**
     * 竞价编号
     */
    private String biddingCode;

    /**
     * 商品编号
     */
    private String goodsCode;

    /**
     * 状态
     */
    private String status;

    /**
     * 下单开始时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date orderStartTime;
    /**
     * 下单结束时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date orderEndTime;

    /**
     * 供应商的id
     */
    private String providerId;


}
