package bidding.service.apiimpl;

import api.BiddingConformityReviewApi;
import bidding.service.service.BiddingConformityReviewService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.BiddingConformReviewAuditListDTO;
import dto.BiddingConformityAuditDTO;
import dto.BiddingConformityReviewInfoDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import query.BiddingConformityReviewAuditListQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author wangtao .
 * @date 2018年3月19日09:50:55
 * 竞价符合性审查api 实现类
 */
@MotanService
public class BiddingConformityReviewApiImpl implements BiddingConformityReviewApi {

    /**
     * 分页获取符合性审查列表
     *
     * @param biddingConformityReviewAuditListQuery BiddingConformityReviewAuditListQuery
     * @return BaseResponse<Page<BiddingConformReviewAuditListDTO>>
     */
    @Override
    public BaseResponse<Page<BiddingConformReviewAuditListDTO>> getBiddingConformityReviewAuditList(BiddingConformityReviewAuditListQuery biddingConformityReviewAuditListQuery) {
        return biddingConformityReviewService.getBiddingConformityReviewAuditList(biddingConformityReviewAuditListQuery);
    }

    /**
     * 获取竞价需求符合性审查数据
     *
     * @param demandCode 竞价需求编号
     * @param auditorId 审核人ID
     * @return BaseResponse<List<BiddingConformityReviewInfoDTO>>
     */
    @Override
    public BaseResponse<List<BiddingConformityReviewInfoDTO>> getBiddingConformityReviewInfo(String demandCode, String auditorId) {
        return biddingConformityReviewService.getBiddingConformityReviewInfo(demandCode ,auditorId);
    }

    /**
     * 符合性审查数据保存
     *
     * @param conformityAudit BiddingConformityAuditDTO
     * @return BaseResponse
     */
    @Override
    public BaseResponse saveBiddingConformityReviewAuditData(BiddingConformityAuditDTO conformityAudit) {
        return biddingConformityReviewService.saveBiddingConformityReviewAuditData(conformityAudit);
    }

    /**
     * 获取竞价小组成员符合性审查审核是否完成
     *
     * @param biddingCode 竞价编号
     * @param auditorId   审核人 ID
     * @return BaseResponse<Boolean>
     */
    @Override
    public BaseResponse<Boolean> isBiddingConformityReviewAuditComplished(String biddingCode, String auditorId,String email) {
        return biddingConformityReviewService.isBiddingConformityReviewAuditComplished(biddingCode, auditorId ,email);
    }

    /**
     * 获取竞价小组成员符合性审查审核提交是否最后一个
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse<Boolean>
     */
    @Override
    public BaseResponse<Boolean> isLastBiddingConformityReviewSubmit(String biddingCode) {
        return biddingConformityReviewService.isLastBiddingConformityReviewSubmit(biddingCode);
    }

    /**
     * 获取符合竞价需求的供应商数量 (要求竞价小组全部审核完成)
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse<Integer>
     */
    @Override
    public BaseResponse<Integer> getBiddingComformanceAuditAvailableCount(String biddingCode) {
        return biddingConformityReviewService.getBiddingComformanceAuditAvailableCount(biddingCode);
    }

    /**
     * 竞价符合性审查服务接口
     */
    private BiddingConformityReviewService biddingConformityReviewService;

    @Autowired
    private void setBiddingConformityReviewService(BiddingConformityReviewService biddingConformityReviewService) {
        this.biddingConformityReviewService = biddingConformityReviewService;
    }
}
