package bidding.service.apiimpl;

import api.BiddingLogApi;
import bidding.service.service.impl.BiddingLogServiceImpl;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.JcbdBiddingOperationLogDto;
import dto.JcbdBiddingPurchaseLogDto;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:51:52
 * 竞价记录api 实现类
 */
@MotanService
public class BiddingLogApiImpl implements BiddingLogApi {

    @Autowired
    BiddingLogServiceImpl biddingLogService;

    @Override
    public void saveBiddingOperationLog(JcbdBiddingOperationLogDto biddingOperationLogDto) {
        biddingLogService.saveBiddingOperationLog(biddingOperationLogDto);
    }

    @Override
    public void saveBiddingOperationLogs(List<JcbdBiddingOperationLogDto> biddingOperationLogDtoList) {
        biddingLogService.saveBiddingOperationLogs(biddingOperationLogDtoList);
    }

    @Override
    public void savePurchaseLog(List<JcbdBiddingPurchaseLogDto> purchaseLogDtos) {
        biddingLogService.savePurchaseLog(purchaseLogDtos);
    }
}
