package bidding.service.apiimpl;

import api.BiddingMainApi;
import bidding.service.service.BiddingMainService;
import bidding.service.service.query.BiddingSupplierOrderManagerService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.Date;
import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:52:50
 * 竞价主管api 实现类
 */
@MotanService
public class BiddingMainApiImpl implements BiddingMainApi {

    @Autowired
    BiddingMainService biddingMainService;
    @Autowired
    BiddingSupplierOrderManagerService biddingSupplierOrderManagerService;

    /**
     * 竞价保存更新接口
     *
     * @param biddingDto
     * @return
     */
    @Override
    public BaseResponse<JcbdBiddingDto> saveOrUpdateBiddingBaseInfo(JcbdBiddingDto biddingDto) {
        return biddingMainService.saveOrUpdateBiddingBaseInfo(biddingDto);
    }

    /**
     * 竞价需求保存更新接口
     *
     * @param biddingDemandDto
     * @return
     */
    @Override
    public BaseResponse saveOrUpdateBiddingDemand(JcbdBiddingDemandDto biddingDemandDto) {
        BaseResponse baseResponse = biddingMainService.saveOrUpdateBiddingDemand(biddingDemandDto);
        return baseResponse;
    }

    /**
     * 竞价删除接口（逻辑删除）
     *
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse deleteBidding(String biddingNo) {

        return biddingMainService.deleteBidding(biddingNo);
    }

    /**
     * 重选竞价小组成员
     *
     * @param chooseBiddingMemberAgainDtoList
     * @return
     */
    @Override
    public BaseResponse chooseBiddingGroupMemberAgain(List<ChooseBiddingMemberAgainDto> chooseBiddingMemberAgainDtoList) {
        return biddingMainService.chooseBiddingGroupMemberAgain(chooseBiddingMemberAgainDtoList);
    }

    /**
     * 竞价需求删除接口（逻辑删除）
     *
     * @param biddingDemandNo
     * @return
     */
    @Override
    public BaseResponse deleteBiddingDemand(String biddingDemandNo) {

        return biddingMainService.deleteBiddingDemand(biddingDemandNo);
    }

    /**
     * 竞价需求审核接口 (竞价小组)
     *
     * @param biddingAudit BiddingAuditDTO
     * @return BaseResponse
     */
    @Override
    public BaseResponse auditBiddingDemand(BiddingAuditDTO biddingAudit) {
        return biddingMainService.auditBiddingDemand(biddingAudit);
    }

    /**
     * 开启报价
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse
     */
    @Override
    public BaseResponse openPrice(String biddingNo) {
        return biddingMainService.openPrice(biddingNo);
    }

    /**
     * 审核商品编码接口
     *
     * @param biddingAuditDTO@return
     */
    @Override
    public BaseResponse auditBiddingSku(BiddingAuditDTO biddingAuditDTO) {
        return biddingMainService.auditBiddingSku(biddingAuditDTO);
    }

    /**
     * 采购下单采购信息保存接口
     *
     * @param jcbdOrderDto
     */
    @Override
    public JcbdOrderDto saveJcbdOrder(JcbdOrderDto jcbdOrderDto) {
        return biddingMainService.saveJcbdOrder(jcbdOrderDto);
    }

    @Override
    public BaseResponse saveBiddingTempOrderInfo(JcbdTempOrderDto jcbdTempOrderDto) {
        return biddingMainService.saveBiddingTempOrderInfo(jcbdTempOrderDto);
    }

    /**
     * 竞价订单状态变更接口
     *
     * @param orderNos
     * @param state
     */
    @Override
    public BaseResponse changeBiddingOrderState(List<String> orderNos, String state) {
        return biddingMainService.changeBiddingOrderState(orderNos,state);
    }

    /**
     * 竞价结束校验定时任务
     *
     * @param biddingNo
     * @return
     */
    @Override
    public BaseResponse biddingResponseFinishValidate(String biddingNo) {
        return biddingMainService.biddingResponseFinishValidate(biddingNo);
    }

    /**
     * 竞价结束校验定时任务
     *
     * @return
     */
    @Override
    public BaseResponse biddingResponseFinishValidateAll() {
        return biddingMainService.biddingResponseFinishValidateAll();
    }

    /**
     * 更新竞价状态接口
     *
     * @param changeStateDto
     * @return
     */
    @Override
    public BiddingStateResponseDto changeBiddingState(BiddingChangeStateDto changeStateDto) {
        return biddingMainService.changeBiddingState(changeStateDto);
    }

    /**
     * 更新竞价开始及结束响应时间
     *
     * @param biddingNo         竞价编号
     * @param timeStartResponse 开始响应时间
     * @param timeEndResponse   结束响应时间
     * @return
     */
    @Override
    public BaseResponse updateBiddingTime(String biddingNo, Date timeStartResponse, Date timeEndResponse) {
        return biddingMainService.updateBiddingTime(biddingNo, timeStartResponse, timeEndResponse);
    }

    @Override
    public List<JcbdBiddingDemandDto> findDemandsByIds(List<String> ids) {
        return null;
    }

    @Override
    public BaseResponse<BiddingResultNotifyDto> finishBiddingResultAudit(String biddingNo) {
        return biddingMainService.finishBiddingResultAudit(biddingNo);
    }

    @Override
    public BaseResponse biddingResultNoPass(String biddingNo) {
        return biddingMainService.biddingResultNoPass(biddingNo);
    }

    @Override
    public BaseResponse finishBiddingOrderAudit(String biddingOrderNo) {
        return biddingMainService.finishBiddingOrderAudit(biddingOrderNo);
    }

    @Override
    public BaseResponse biddingOrderAuditNoPass(String orderNo) {
        return biddingMainService.biddingOrderAuditNoPass(orderNo);
    }

    @Override
    public BaseResponse deleteTempOrderById(List<String> tempOrderId) {
        return biddingMainService.deleteTempOrderById(tempOrderId);
    }

    @Override
    public void deleteTempOrderByBiddingCode(String biddingCode) {
        biddingMainService.deleteTempOrderByBiddingCode(biddingCode);
    }

    @Override
    public JcbdTempOrderDto modifyTempOrderById(String tempOrderId) {
        return biddingMainService.modifyTempOrderById(tempOrderId);
    }


    @Override
    public BaseResponse finishBidding(String biddingNo) {
        return biddingMainService.finishBidding(biddingNo);
    }

    @Override
    public String updateBiddingVoteNo(String biddingNo) {
        return biddingMainService.updateBiddingVoteNo(biddingNo);
    }

    @Override
    public String updateBiddingGroupCheckNo(String biddingNo) {
        return biddingMainService.updateBiddingGroupCheckNo(biddingNo);
    }

    @Override
    public BaseResponse updateBiddingResultResult(String biddingNo, String remark) {
        return biddingMainService.updateBiddingResultResult(biddingNo, remark);
    }

    @Override
    public void changeBiddingGroupMemberStatus(String biddingNo, String auditorId, String status, String email) {
        biddingMainService.changeBiddingGroupMemberStatus(biddingNo, auditorId, status, email);
    }

    @Override
    public BaseResponse<Boolean> getVoteStatus(String biddingNo,String memberId) {
      return   biddingMainService.getVoteStatus(biddingNo,memberId);
    }

//    @Override
//    public String getOperatorName(String operatorId) {
//        return biddingMainService.getOperatorName(operatorId);
//    }

    @Override
    public BaseResponse<String> getBiddingNo() {
        return biddingMainService.getBiddingNo();
    }

    @Override
    public Boolean findTempOrderBySkus(List<String> skus) {
        return biddingMainService.findTempOrderBySkus(skus);
    }


    @Override
    public BaseResponse changeGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email) {
        return biddingMainService.changeGroupMemberConfomanceCheck(biddingNo,auditorId,email);
    }

    @Override
    public BaseResponse cancelGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email) {
        return biddingMainService.cancelGroupMemberConfomanceCheck(biddingNo,auditorId,email);
    }

    @Override
    public JcbdBiddingGroupMemberDto findByMemberId(String operatorId) {
        return biddingMainService.findByMemberId(operatorId);
    }
}
