package bidding.service.apiimpl;

import api.BiddingResponseApi;
import bidding.service.service.BiddingResponseService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

/**
 * @author wangtao.
 * @date 2018年3月19日09:53:47
 * 竞价响应api 实现类
 */
@MotanService
public class BiddingResponseApiImpl implements BiddingResponseApi {

    @Autowired
    BiddingResponseService biddingResponseService;

    /**
     * 供应商竞价响应接口
     *
     * @param supplierBiddingResponseDto
     * @return
     */
    @Override
    public BaseResponse supplierBiddingResponse(SupplierBiddingResponseDto supplierBiddingResponseDto) {
        return biddingResponseService.supplierBiddingResponse(supplierBiddingResponseDto);
    }

    /**
     * 更新供应商竞价需求响应接口（sku等）
     * 也可用于保存新的竞价需求响应
     *
     * @param jcbdBiddingDemandResponseDto
     * @return
     */
    @Override
    public BaseResponse updateBiddingDemandResponse(JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto) {
        return biddingResponseService.updateBiddingDemandResponse(jcbdBiddingDemandResponseDto);
    }

    @Override
    public BaseResponse updateBiddingDemandResponseSku(UpdateSkuDto updateSkuDto) {
        return biddingResponseService.updateBiddingDemandResponseSku(updateSkuDto);
    }

    @Override
    public BiddingStateResponseDto supplierBiddingStatusChange(BiddingSupplierChangeStateDto biddingChangeStateDto) {
        return biddingResponseService.supplierBiddingStatusChange(biddingChangeStateDto);
    }

    @Override
    public BaseResponse supplierInitStatus(String biddingNo) {
        return biddingResponseService.supplierInitStatus(biddingNo);
    }

    @Override
    public BaseResponse supplierInitModifySku(String biddingNo, String supplierId) {
        return biddingResponseService.supplierInitModifySku(biddingNo, supplierId);
    }

    @Override
    public BaseResponse responseGiveUp(String biddingNo, String supplierId) {
        return biddingResponseService.responseGiveUp(biddingNo,supplierId);
    }
}
