package bidding.service.apiimpl;

import api.BiddingVoteApi;
import bidding.service.service.BiddingVoteService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.VoteDetailDto;
import dto.VoteQueryResultDto;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:54:52
 * 竞价投票api 实现类
 */
@MotanService
public class BiddingVoteApiImpl implements BiddingVoteApi {

    @Autowired
    BiddingVoteService biddingVoteService;

    /**
     * 系统随机确认供应商
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse
     */
    @Override
    public BaseResponse randomConfirmSupplier(String biddingCode) {
        return biddingVoteService.randomConfirmSupplier(biddingCode) ;
    }

    /**
     * 投票接口
     *
     * @param voteDetailDto
     */
    @Override
    public BaseResponse voteSelectionSupplier(VoteDetailDto voteDetailDto) {
        return biddingVoteService.voteSelectionSupplier(voteDetailDto) ;
    }

    @Override
    public List<VoteQueryResultDto> voteDetailsQuery(String biddingNo) {
        return biddingVoteService.voteDetailsQuery(biddingNo);
    }
}
