package bidding.service.apiimpl.query;

import api.query.BdDemandCodeRuleApi;
import api.query.BiddingCodeRuleApi;
import bidding.service.service.query.BdDemandCodeRuleService;
import bidding.service.service.query.BiddingCodeRuleService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @program: parent
 * @author: taofeng
 * @create: 2018-04-18
 * <p>
 * 针对demandCode的查询接口
 **/
@MotanService
public class BdDemandCodeRuleApiImpl implements BdDemandCodeRuleApi {

    @Autowired
    BdDemandCodeRuleService bdDemandCodeRuleService;

    /**
     * @author taofeng
     * @date 2018/4/18
     * <p>
     * 查询出最大的demandCode
     */
    @Override
    public String findMaxBemandCode() {
        return bdDemandCodeRuleService.findMaxBemandCode();
    }

    /**
     * @author taofeng
     * @date 2018/4/19
     * <p>
     * 根据biddingId查询demandCode的count
     */
    @Override
    public Integer findDemandCountByBid(String biddingId) {
        return bdDemandCodeRuleService.findDemandCountByBid(biddingId);
    }
}
