package bidding.service.apiimpl.query;

import api.query.BiddingConformityReviewQueryApi;
import bidding.service.service.query.BiddingConformityReviewQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:40:18.
 * 符合性审查api实现类.
 */

@MotanService
public class BiddingConformityReviewQueryApiImpl implements BiddingConformityReviewQueryApi {

    @Autowired
    BiddingConformityReviewQueryService biddingConformityReviewQueryService;

    /**
     * 获取竞价小组成员信息
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<JcbdBiddingGroupMemberDto>>
     */
    @Override
    public BaseResponse<List<JcbdBiddingGroupMemberDto>> findBiddingGroupMember(String biddingNo) {
        return biddingConformityReviewQueryService.findBiddingGroupMember(biddingNo);
    }

    /**
     * 符合性审查需求查询接口
     *
     * @param biddingId
     * @return
     */
    @Override
    public List<JcbdBiddingDemandDto> findDemands(String biddingId) {
        return null;
    }

    /**
     * 获取符合性审核列表dto  符合性审核页
     * @param conformityQueryDto
     * @return
     */
    @Override
    public Page<BiddingConformityListDto> getConformityListByQueryDto(BiddingConformityQueryDto conformityQueryDto) {
        return biddingConformityReviewQueryService.getConformityListByQueryDto(conformityQueryDto);
    }

    @Override
    public List<JcbdBiddingDemandResponseDto> getConformityAuditInfo(String demandCode) {
        return biddingConformityReviewQueryService.getConformityAuditInfo(demandCode);
    }

    @Override
    public BaseResponse<List<BiddingResponseOutlineDto>> queryConformityOutline(BiddingConformityQueryDto conformityQueryDto) {
        return biddingConformityReviewQueryService.queryConformityOutline(conformityQueryDto);
    }

    @Override
    public BaseResponse<JcbdBiddingDemandResponseDto> getConformityDetail(BiddingConformityQueryDto conformityQueryDto) {
        return biddingConformityReviewQueryService.getConformityDetail(conformityQueryDto);
    }

    @Override
    public void deleteComplianceAudit(String biddingNo, String email,String groupMemberId) {
         biddingConformityReviewQueryService.deleteComplianceAudit(biddingNo,email,groupMemberId);
    }


}
