package bidding.service.apiimpl.query;

import api.query.BiddingLogQueryApi;
import bidding.service.service.query.BiddingLogQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.JcbdBiddingOperationLogDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:43:21.
 * 竞价日志查询api 实现类
 */
@MotanService
public class BiddingLogQueryApiImpl implements BiddingLogQueryApi {

    @Autowired
    BiddingLogQueryService biddingLogQueryService;
    /**
     * 查询某竞价需求的操作记录
     *
     * @param biddingNo
     * @return
     */
    @Override
    public Page<JcbdBiddingOperationLogDto> findAllByBiddingNo(String biddingNo, Pageable pageable) {
        return biddingLogQueryService.findAllByBiddingNo(biddingNo,pageable);
    }

}
