package bidding.service.apiimpl.query;

import api.query.BiddingMainQueryApi;
import bidding.service.service.query.BiddingMainQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import query.BiddingDemandListQuery;
import sinomall.global.common.response.BaseResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:44:36.
 * 竞价主管查询api 实现类
 */
@MotanService
public class BiddingMainQueryApiImpl implements BiddingMainQueryApi {

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    BiddingMainQueryService biddingMainQueryService;
    

    @Override
    public JcbdBiddingDto queryBidding(String biddingNo) {
        return biddingMainQueryService.queryBidding(biddingNo);
    }

    /**
     * 获取采购商品集合
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<BiddingPurchaseGoodsDTO>>
     */
    @Override
    public BaseResponse<List<BiddingPurchaseGoodsDTO>> getPurchaseGoods(String biddingNo) {
        return null;
    }

    /**
     * 竞价列表查询接口
     *
     * @param jcbdBiddingQueryDto
     * @return
     */
    @Override
    public Page<JcbdBiddingQueryResultDto> operatorFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        return biddingMainQueryService.operatorFindJcbdBiddingByParams(jcbdBiddingQueryDto);
    }

    /**
     * 供应商竞价列表查询
     *
     * @param jcbdBiddingQueryDto
     * @return
     */
    @Override
    public Page<JcbdBiddingQueryResultDto> supplierFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto) {
        return biddingMainQueryService.supplierFindJcbdBiddingByParams(jcbdBiddingQueryDto);
    }

    /**
     * 竞价需求查询(概要) 通过竞价编号查询竞价需求列表
     *
     * @param biddingDemandListQuery
     * @return
     */
    @Override
    public BaseResponse<Page<BiddingDemandQueryDto>> getBiddingDemandList(BiddingDemandListQuery biddingDemandListQuery) {
        return biddingMainQueryService.getBiddingDemandList(biddingDemandListQuery);
    }

    /**
     * 竞价需求查询(详细)
     *
     * @param demandCode
     * @return
     */
    @Override
    public BaseResponse<JcbdBiddingDemandDto> getBiddingDemandInfo(String demandCode) {
        return biddingMainQueryService.getBiddingDemandInfo(demandCode);
    }

    /**
     * 竞价概要信息查询
     *
     * @param biddingCode
     * @return
     */
    @Override
    public BaseResponse<JcbdBiddingDto> getBiddingByBiddingCode(String biddingCode) {
       return biddingMainQueryService.getBiddingByBiddingCode(biddingCode);
    }

    /**
     * 查找特定一个JcbdBiddingDemandDto
     * @param jcbdBiddingDemandDto
     * @return
     */
    @Override
    public JcbdBiddingDemandDto getBiddingDemandFindOne(JcbdBiddingDemandDto jcbdBiddingDemandDto) {
        return biddingMainQueryService.getBiddingDemandFindOne(jcbdBiddingDemandDto);
    }

    @Override
    public List<ProcureInformationDto> getBiddingDemandSku(String biddingCode) {
        return  biddingMainQueryService.getBiddingDemandSku(biddingCode);
    }

    @Override
    public List<TempBatchDto> getTempBatchList(String biddingNo) {
        return   biddingMainQueryService.getTempBatchList(biddingNo);
    }

    @Override
    public List<JcbdTempOrderDto> findAllTempOrderByBiddingNo(String biddingNo) {
        return biddingMainQueryService.findAllTempOrderByBiddingNo(biddingNo);
    }

    @Override
    public JcbdBdProviderDto getTransactionSupplier(String biddingNo) {
        return biddingMainQueryService.getTransactionSupplier(biddingNo);
    }

    @Override
    public JcbdBdProviderDto getProvider(String biddingNo, String supplierId) {
        return biddingMainQueryService.getProvider(biddingNo, supplierId);
    }

    @Override
    public BaseResponse<JcbdBiddingDto> findOne(String biddingId) {
        return biddingMainQueryService.findOne(biddingId);
    }

    @Override
    public BigDecimal getBiddingGeneralBudget(String biddingNo) {
        return biddingMainQueryService.getBiddingGeneralBudget(biddingNo);
    }
}
