package bidding.service.apiimpl.query;

import api.query.BiddingMallOrderQueryApi;
import bidding.service.service.query.BiddingMallOrderQueryService;
import bidding.service.service.query.BiddingOrderQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.BiddingOrderInfoDto;
import dto.JcbdBiddingOrderItemDto;
import dto.JcbdMallOrderDto;
import dto.JcbdOrderDto;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
/**
* @author luoxianwei
* @date 2018/4/14
*/
@MotanService
public class BiddingMallOrderQueryApiImpl implements BiddingMallOrderQueryApi {

    @Autowired
    BiddingMallOrderQueryService biddingMallOrderQueryService;
    @Autowired
    BiddingOrderQueryService biddingOrderQueryService;

    @Override
    public List<JcbdMallOrderDto> findByJcbdOrderId(String jcbdOrderId) {
        return biddingMallOrderQueryService.findByJcbdOrderId(jcbdOrderId);
    }

    @Override
    public JcbdMallOrderDto updateStatusByOrderNo(String status, String orderNo) {
        return  biddingMallOrderQueryService.updateStatusByOrderNo(status, orderNo);
    }

    @Override
    public JcbdMallOrderDto deleteJcbdMallOrderByOrderNo(String orderNo) {
        return biddingMallOrderQueryService.deleteJcbdMallOrderByOrderNo(orderNo);
    }

    @Override
    public BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo) {
        return biddingMallOrderQueryService.getOrderInfoByOrderNo(orderNo);
    }

    /**
     * 获取订单
     *
     * @param orderNo orderNo
     * @return JcbdMallOrderDto
     */
    @Override
    public JcbdMallOrderDto findByOrderNo(String orderNo) {
        return biddingMallOrderQueryService.findByOrderNo(orderNo);
    }

    /**
     * 更新订单状态
     *
     * @param mallOrderNo                  String
     * @param status              String
     * @param supplierOrderStatus String
     */
    @Override
    public void updateStatusAndSupplierStatus(String mallOrderNo, String status, String supplierOrderStatus) {
        biddingMallOrderQueryService.updateStatusAndSupplierStatus(mallOrderNo, status, supplierOrderStatus);
    }

    /**
     *  取消购买记录订单
     * @param orderNo
     */
    @Override
    public void cancelPurchaseLogOrder(String orderNo) {
        biddingMallOrderQueryService.cancelPurchaseLogOrder(orderNo);
    }
}
