package bidding.service.apiimpl.query;

import api.query.BiddingOrderQueryApi;
import bidding.service.service.query.BiddingOrderQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
@MotanService
public class BiddingOrderQueryApiImpl implements BiddingOrderQueryApi {

    @Autowired
    BiddingOrderQueryService biddingOrderQueryService;


    @Override
    public List<JcbdOrderDto> findByJcbdBiddingId(String biddingCode) {
        return biddingOrderQueryService.findByJcbdBiddingId(biddingCode);
    }

    @Override
    public List<JcbdOrderDto> findAllByBiddingCode(String biddingCode) {
        return biddingOrderQueryService.findAllByBiddingCode(biddingCode);
    }

    @Override
    public List<JcbdBiddingPurchaseLogDto> findPurchaseLogs(JcbdBiddingPurchaseLogDto purchaseLogDto) {
        return biddingOrderQueryService.findPurchaseLogs(purchaseLogDto);
    }

    @Override
    public BiddingOrderAffiliationDto checkIsBiddingOrder(String parentOrderNo) {
        return biddingOrderQueryService.checkIsBiddingOrder(parentOrderNo);
    }

    @Override
    public JcbdOrderDto findJcbdOrder(String bdOrderNo) {
        return biddingOrderQueryService.findJcbdOrder(bdOrderNo);
    }

    @Override
    public List<JcbdTempOrderDto> findTempOrderByBiddingCode(String biddingCode) {
        return biddingOrderQueryService.findTempOrderByBiddingCode(biddingCode);
    }

    @Override
    public BiddingOrderOutlineInfoDto findOrderOutlineInfo(String orderNo) {
        return biddingOrderQueryService.findOrderOutlineInfo(orderNo);
    }

    /**
     * 获取竞价订单
     *
     * @param id
     * @return JcbdOrderDto
     */
    @Override
    public JcbdOrderDto findById(String id) {
        return biddingOrderQueryService.findById(id);
    }

    @Override
    public BaseResponse queryBiddingOrderNoByMallOrderNo(String mallOrderNo) {
        return biddingOrderQueryService.queryBiddingOrderNoByMallOrderNo(mallOrderNo);
    }

    /**
     * 修改订单状态
     * @param orderNo
     * @param status
     * @return
     */
    @Override
    public JcbdOrderDto updateStatus(String orderNo, String status) {
        return biddingOrderQueryService.updateStatus(orderNo,status);
    }

}
