package bidding.service.apiimpl.query;


import api.query.BiddingQueryApi;
import bidding.service.service.query.BiddingQueryService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import query.BiddingOrderManagerListQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
* @author luoxianwei
* @date 2018/4/14
*/
@MotanService
public class BiddingQueryApiImpl implements BiddingQueryApi {

    @Autowired
    BiddingQueryService biddingQueryService;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;

    @Override
    public JcbdBiddingDto findByBiddingCodeAndIsDelete(String biddingCode) {
        return biddingQueryService.findByBiddingCodeAndIsDelete(biddingCode);
    }

    @Override
    public List<JcbdBiddingDto> findAllJcbdBidding() {
        return biddingQueryService.findAllJcbdBidding();
    }

    @Override
    public List<JcbdBiddingDto> findJcbdBiddingByBiddingNo(List<String> binddingNo) {
        return biddingQueryService.findJcbdBiddingByBiddingNo(binddingNo);
    }

    @Override
    public List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode, String status, String module) {
        return biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex(roleCode,status,module);
    }

    @Override
    public List<JcbdBdProviderDto> findByBiddingNoAndStatus(String biddingNo, String status) {
        return biddingQueryService.findByBiddingNoAndStatus(biddingNo,status);
    }

    @Override
    public JcbdBiddingGroupMemberDto findGroupStatus( String email,String biddingId) {
        return biddingQueryService.findGroupStatus(email,biddingId);
    }
}
