package bidding.service.apiimpl.query;

import api.query.BiddingResponseQueryApi;
import bidding.service.service.query.BiddingResponseQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import query.BiddingDemandListQuery;
import query.BiddingDemandRespQuery;
import query.SupplierBiddingDamandQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:46:55
 * 竞价响应查询api 实现类
 */
@MotanService
public class BiddingResponseQueryApiImpl implements BiddingResponseQueryApi {

    @Autowired
    BiddingResponseQueryService biddingResponseQueryService;

    /**
     * 新建竞价时获取当前所有可用供应商
     * <p>
     * 调用外部接口
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<BiddingSupplierDTO>>
     */
    @Override
    public BaseResponse<List<BiddingSupplierDTO>> getAllSupplier(String biddingNo) {
        return biddingResponseQueryService.getAllSupplier(biddingNo);
    }

    /**
     * 验证供应商响应sku有效性接口
     *
     * @param storeId
     * @param skus
     * @return 有效则返回商品链接
     */
    @Override
    public ProvSkuEffectieResultDto provBiddingSkuEffective(String storeId, List<String> skus) {
        return null;
    }

    /**
     * 查询竞价需求最终成交供应商信息
     *
     * @param demandCode
     * @return
     */
    @Override
    public BaseResponse<BiddingResultSupplierInfoQueryDto> getBiddingResultSupplierInfo(String demandCode) {
        return biddingResponseQueryService.getBiddingResultSupplierInfo(demandCode);
    }

    /**
     * 供应商需求响应查询接口
     * @param biddingDemandRespQuery 参数参数
     * @return
     */
    @Override
    public BaseResponse<JcbdBiddingDemandResponseDto> queryBiddingDemandResponse(BiddingDemandRespQuery biddingDemandRespQuery) {
        return biddingResponseQueryService.queryBiddingDemandResponse(biddingDemandRespQuery);
    }


    /**
     * 供应商竞价响应 需求概要信息查询(供应商)
     * @param supplierBiddingDamandQuery 查询参数
     * @return
     */
    @Override
    public BaseResponse<Page<BiddingResponseDemandOutlineDto>> supplierBiddingResponseDemandOutline(SupplierBiddingDamandQuery supplierBiddingDamandQuery) {
        return biddingResponseQueryService.supplierBiddingResponseDemandOutline(supplierBiddingDamandQuery);
    }

    /**
     * 供应商竞价响应概要信息查询
     * @param biddingNo 竞价编号
     * @param demandCode 需求编号
     * @return
     */
    @Override
    public BaseResponse<List<BiddingResponseOutlineDto>> queryBiddingResponseOutline(String biddingNo,String demandCode) {
        return biddingResponseQueryService.queryBiddingResponseOutline(biddingNo,demandCode);
    }

    /**
     * 比价信息查询
     *
     * @param biddingNo 竞价编号
     * @return
     */
    @Override
    public BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo) {
        return biddingResponseQueryService.queryBiddingPriceParity(biddingNo);
    }

    /**
     *批量查询竞价响应
     * @param demandRspIds
     * @return
     */
    @Override
    public List<JcbdBiddingDemandResponseDto> findAll(List<String> demandRspIds) {
        return biddingResponseQueryService.findAll(demandRspIds);
    }

    @Override
    public BaseResponse isAllDemandAreResponse(String jcbdBiddingNo, String responseProviderId) {
        return biddingResponseQueryService.isAllDemandAreResponse(jcbdBiddingNo,responseProviderId);
    }

    @Override
    public BaseResponse demandResponseIsAllAccord(String jcbdBiddingNo, String responseProviderId) {
        return biddingResponseQueryService.demandResponseIsAllAccord(jcbdBiddingNo,responseProviderId);
    }

    @Override
    public Page<DemandResponseQueryDto> findDemandAndResponse(DemanResponseParmDto parms) {
        return biddingResponseQueryService.findDemandAndResponse(parms);
    }

    @Override
    public List<String> findBiddingResponseSkus(String jcbdBiddingNo, String supplierId) {
        return biddingResponseQueryService.findBiddingResponseSkus(jcbdBiddingNo, supplierId);
    }

    /**
     * 通过竞价编号查询已成交供应商需求响应列表
     *
     * @param biddingDemandListQuery
     * @return
     */
    @Override
    public BaseResponse<Page<BiddingResultDemandQueryDto>> getBiddingResultDemandList(BiddingDemandListQuery biddingDemandListQuery) {
        return biddingResponseQueryService.getBiddingResultDemandList(biddingDemandListQuery);
    }

    @Override
    public JcbdBiddingDemandResponseDto findProviderResponsePrice(String biddingNo, String sku) {
        return biddingResponseQueryService.findProviderResponsePrice(biddingNo,sku);
    }

    @Override
    public BaseResponse findModifySkuFlag(String biddingNo, String supplierId) {
        return biddingResponseQueryService.findModifySkuFlag(biddingNo, supplierId);
    }

    @Override
    public JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId) {
        return biddingResponseQueryService.getProviderByBiddingNoAndSupplierId(biddingId,supplierId);
    }
}
