package bidding.service.apiimpl.query;

import api.query.BiddingRoleOperationQueryApi;
import bidding.model.po.JcbdRoleOperation;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import dto.JcbdRoleOperationDto;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import query.BiddingOperatorQuery;
import utils.Lang;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018年3月19日09:48:02
 * 竞价状态查询api 实现类
 */
@MotanService
public class BiddingRoleOperationQueryApiImpl implements BiddingRoleOperationQueryApi {

    @Autowired
    MapperFacade mapperFacade;

    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;

    @Override
    public List<JcbdRoleOperationDto> getAllStatusByRoles(List<String> roleCodes) {
        List<JcbdRoleOperation> allStatusByRoles = biddingRoleOperationQueryService.getAllStatusByRoles(roleCodes);
        if (Lang.isEmpty(allStatusByRoles)){
            return null;
        }
        return mapperFacade.mapAsList(allStatusByRoles,JcbdRoleOperationDto.class);
    }

    @Override
    public List<JcbdRoleOperationDto> findByRoleCodeAndStatus(String roleCode, String status) {
        return biddingRoleOperationQueryService.findByRoleCodeAndStatus(roleCode,status);
    }

    @Override
    public List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode, String status, String module) {
        return biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex(roleCode,status,module);
    }

    @Override
    public List<JcbdRoleOperationDto> getOperatorBiddingOperateByBiddingCode(BiddingOperatorQuery biddingOperatorQuery) {
        return biddingRoleOperationQueryService.getOperatorBiddingOperateByBiddingCode(biddingOperatorQuery);
    }

    @Override
    public List<String> getBiddingShowTitle(String status, String module) {
        return biddingRoleOperationQueryService.getBiddingShowTitle(status,module);
    }

    @Override
    public List<JcbdRoleOperationDto> getSupplierBiddingOperateByBiddingCode(String biddingNo, String status) {
        return biddingRoleOperationQueryService.getSupplierBiddingOperateByBiddingCode(biddingNo, status);
    }
}
