package bidding.service.config;


import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.redis.core.RedisTemplate;
import utils.lock.RedisLockUtil;

/**
 * @author 陈圣融
 * @date 2018-03-14
 **/
@Configuration
@EntityScan(basePackages = {"bidding.model.po"})
@EnableJpaRepositories(basePackages = {"bidding.model.repository"})
public class JpaConfig {
    @Bean
    RedisLockUtil redisLockUtil(RedisTemplate redisTemplate) {
        return new RedisLockUtil(redisTemplate);
    }
}
