package bidding.service.config;

import api.BiddingLogApi;
import bidding.service.service.BiddingLogService;
import com.alibaba.fastjson.JSON;
import dto.BiddingChangeStateDto;
import dto.BiddingStateResponseDto;
import dto.JcbdBiddingOperationLogDto;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;

/**
 * Created by xiaoxu on 2018/3/25.
 * @author junyang.dong
 */
@Aspect
@Component
@Slf4j
public class LogAspect {

    @Autowired
    private BiddingLogApi biddingLogApi;

    @AfterReturning(returning = "returnValue",value = "execution(* bidding.service.service.BiddingMainService.changeBiddingState(..))")
    public void saveOperatorLog(JoinPoint joinPoint,Object returnValue) {
        log.info("目标方法返回值："+returnValue);
//        try {
//            // 获取目标方法的参数
//            Object[] parms = joinPoint.getArgs();
//            Object parm = parms[0];
//            BiddingChangeStateDto biddingChangeStateDto = (BiddingChangeStateDto) parm;
//            log.info("目标方法参数："+ JSON.toJSONString(biddingChangeStateDto));
//            BiddingStateResponseDto biddingStateResponseDto = (BiddingStateResponseDto) returnValue;
//            JcbdBiddingOperationLogDto operationLogDto = new JcbdBiddingOperationLogDto();
//            operationLogDto.setBiddingId(biddingStateResponseDto.getBiddingId());
//            operationLogDto.setOperationTime(biddingChangeStateDto.getOperationTime());
//            operationLogDto.setOperatorName(biddingChangeStateDto.getOperatorName());
//            operationLogDto.setOperationContent(biddingChangeStateDto.getOperationContent());
//            operationLogDto.setRemark(biddingChangeStateDto.getRemark());
//            biddingLogApi.saveBiddingOperationLog(operationLogDto);
//        }catch (Exception e){
//            log.info("LogAspect.saveOperatorLog:日志记录保存失败!");
//        }

    }

}
