package bidding.service.service;

import dto.*;
import org.springframework.data.domain.Page;
import query.BiddingConformityReviewAuditListQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * 竞价符合性审查业务逻辑层接口
 *
 * @author Drury
 * @date 2018/3/19
 */
public interface BiddingConformityReviewService {

    /**
     * 分页获取符合性审查列表
     *
     * @param biddingConformityReviewAuditListQuery BiddingConformityReviewAuditListQuery
     * @return BaseResponse<Page<BiddingConformReviewAuditListDTO>>
     */
    BaseResponse<Page<BiddingConformReviewAuditListDTO>> getBiddingConformityReviewAuditList(BiddingConformityReviewAuditListQuery biddingConformityReviewAuditListQuery);

    /**
     * 获取竞价需求符合性审查数据
     *
     * @param demandCode 竞价需求编号
     * @param auditorId 审核人ID
     * @return BaseResponse<List<BiddingConformityReviewInfoDTO>>
     */
    BaseResponse<List<BiddingConformityReviewInfoDTO>> getBiddingConformityReviewInfo(String demandCode, String auditorId);

    /**
     * 符合性审查数据保存
     *
     * @param conformityAudit BiddingConformityAuditDTO
     * @return BaseResponse
     */
    BaseResponse saveBiddingConformityReviewAuditData(BiddingConformityAuditDTO conformityAudit);

    /**
     * 获取竞价小组成员符合性审查审核是否完成
     * @param biddingCode 竞价编号
     * @param auditorId 审核人 ID
     * @return BaseResponse<Boolean>
     */
    BaseResponse<Boolean> isBiddingConformityReviewAuditComplished(String biddingCode, String auditorId,String email);

    /**
     * 获取竞价小组成员符合性审查审核提交是否最后一个
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse<Boolean>
     */
    BaseResponse<Boolean> isLastBiddingConformityReviewSubmit(String biddingCode);

    /**
     * 获取符合竞价需求的供应商数量 (要求竞价小组全部审核完成)
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse<Integer>
     */
    BaseResponse<Integer> getBiddingComformanceAuditAvailableCount(String biddingCode);



    Page<JcbdBiddingQueryResultDto> supplierFindJcbdBiddingByParams(JcbdBiddingQueryDto jcbdBiddingQueryDto);

}
