package bidding.service.service;

import bidding.model.po.BiddingStatusCategory;
import bidding.model.po.BiddingStatusTransform;
import dto.*;
import sinomall.global.common.response.BaseResponse;

import java.util.Date;
import java.util.List;

/**
 * 竞价主管业务逻辑层接口
 *
 * @author Drury
 * @date 2018/3/19
 */
public interface BiddingMainService {
    public static final String BIDDING_STATUS_CATEGORY_BIDDING = "BIDDING_STATUS";
    public static final String BIDDING_STATUS_CATEGORY_SUPPLIER = "SUPPLIER_BIDDING_STATUS";

    /**
     * 竞价保存更新接口
     *
     * @param biddingDto
     * @return
     */
    BaseResponse<JcbdBiddingDto> saveOrUpdateBiddingBaseInfo(JcbdBiddingDto biddingDto);


    /**
     * 竞价需求保存更新接口
     *
     * @param biddingDemandDto
     * @return
     */
    BaseResponse saveOrUpdateBiddingDemand(JcbdBiddingDemandDto biddingDemandDto);


    /**
     * 竞价删除接口（逻辑删除）
     *
     * @param biddingNo
     * @return
     */
    public BaseResponse deleteBidding(String biddingNo);


    /**
     * 竞价需求删除接口（逻辑删除）
     *
     * @param biddingDemandNo
     * @return
     */
    public BaseResponse deleteBiddingDemand(String biddingDemandNo);


    /**
     * 更新竞价状态
     *
     * @param changeStateDto
     * @return
     */
    BiddingStateResponseDto changeBiddingState(BiddingChangeStateDto changeStateDto);

    /**
     * 获取竞价流转
     *
     * @param changeStateDto
     * @param biddingStatusCategory
     * @return
     */
    public BiddingStatusTransform getBiddingStatusTransform(BiddingChangeStateDto changeStateDto, BiddingStatusCategory biddingStatusCategory);

    /**
     * 更新竞价开始及结束响应时间
     *
     * @param biddingNo
     * @param timeStartResponse
     * @param timeEndResponse
     * @return
     */
    BaseResponse updateBiddingTime(String biddingNo, Date timeStartResponse, Date timeEndResponse);

    /**
     * 重选竞价小组成员
     *
     * @param chooseBiddingMemberAgainDtoList
     * @return
     */
    BaseResponse chooseBiddingGroupMemberAgain(List<ChooseBiddingMemberAgainDto> chooseBiddingMemberAgainDtoList);


    /**
     * 竞价需求审核接口 (竞价小组)
     *
     * @param biddingAudit BiddingAuditDTO
     * @return BaseResponse
     */
    BaseResponse auditBiddingDemand(BiddingAuditDTO biddingAudit);

    /**
     * 开启报价
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse
     */
    BaseResponse openPrice(String biddingNo);

    /**
     * 竞价结束校验定时任务，扫描所有过期竞价信息
     *
     * @return
     */
    BaseResponse<List<JcbdBiddingDto>> biddingResponseFinishValidateAll();

    /**
     * 根据竞价编号扫描竞价信息
     *
     * @param biddingNo
     * @return
     */
    BaseResponse biddingResponseFinishValidate(String biddingNo);

    /**
     * 审核商品编码接口
     *
     * @param
     * @return
     */
    BaseResponse auditBiddingSku(BiddingAuditDTO biddingAuditDTO);

    /**
     * 竞价结果审核不通过
     *
     * @param biddingNo
     * @return
     */
    BaseResponse biddingResultNoPass(String biddingNo);

    /**
     * 竞价结果审核通过
     *
     * @param biddingNo
     * @return
     */
    BaseResponse<BiddingResultNotifyDto> finishBiddingResultAudit(String biddingNo);

    /**
     * 完成竞价订单审核
     *
     * @param biddingOrderNo
     * @return
     */
    BaseResponse finishBiddingOrderAudit(String biddingOrderNo);

    /**
     * 竞价订单审核不通过
     *
     * @param orderNo
     * @return
     */
    BaseResponse biddingOrderAuditNoPass(String orderNo);

    /**
     * 采购下单临时订单保存接口
     * @param jcbdTempOrderDto
     * @return
     */
    BaseResponse saveBiddingTempOrderInfo(JcbdTempOrderDto jcbdTempOrderDto);

    /**
     * 保存采购的订单信息到大订单
     * @param jcbdOrderDto
     * @return
     */
    JcbdOrderDto saveJcbdOrder(JcbdOrderDto jcbdOrderDto);

    /**
     * 删除指定临时订单
     * @param tempOrderId
     * @return
     */
    BaseResponse deleteTempOrderById(List<String> tempOrderId);

     /**
     *删除竞价下的临时订单
     * @param biddingCode
     */
    void deleteTempOrderByBiddingCode(String biddingCode);

    /**
     * 返回要修改临时订单信息
     * @param tempOrderId
     * @return
     */
    JcbdTempOrderDto modifyTempOrderById(String tempOrderId);
	
    /**
     * 终止竞价
     * @param biddingNo
     * @return
     */
    BaseResponse finishBidding(String biddingNo);

    /**
     * 更新竞价投票编号
     * @param biddingNo
     * @return 更新后的投票编号
     */
    String updateBiddingVoteNo(String biddingNo);

    /**
     * 更新竞价审核编号
     * @param biddingNo
     * @return
     */
    String updateBiddingGroupCheckNo(String biddingNo);

    /**
     * 更新提交竞价结果审核备注
     * @param biddingNo
     * @param remark
     * @return
     */
    BaseResponse updateBiddingResultResult(String biddingNo, String remark);
    /**
     * 改变竞价小组成员状态
     * @param auditorId 小组成员id
     */
    void changeBiddingGroupMemberStatus(String biddingNo,String auditorId,String status,String emil);

    /**
     * 获取是否需要投票情况，决定是否显示投票标签
     * @param biddingNo
     * @return
     */
    BaseResponse<Boolean> getVoteStatus(String biddingNo,String memberId);

    /**
     * 获取竞价操作人姓名
     * @param operatorId
     * @return
     */
//    String getOperatorName(String operatorId);

    /**
     * 生成竞价编号
     * @return
     */
    BaseResponse<String> getBiddingNo();

    /**
     * 根据sku列表查查询临时订单
     * @param skus
     * @return
     */
    Boolean findTempOrderBySkus(List<String> skus);


    /**
     * 更改为已进行符合性审查
     * @param biddingNo
     * @param auditorId
     * @param email
     * @return
     */
    BaseResponse changeGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email);

    /**
     * 更改为已进行符合性审查
     * @param biddingNo
     * @param auditorId
     * @param email
     * @return
     */
    BaseResponse cancelGroupMemberConfomanceCheck(String biddingNo, String auditorId, String email);

    /**
     * 更改竞价订单状态
     * @param orderNos
     * @param state
     * @return
     */
    BaseResponse changeBiddingOrderState(List<String> orderNos, String state);

    /**
     * 根据登录人Id查询成员信息
     * @param operatorId
     * @return
     */
    JcbdBiddingGroupMemberDto findByMemberId(String operatorId);


}
