package bidding.service.service;

import dto.*;
import sinomall.global.common.response.BaseResponse;

/**
 * 竞价响应业务逻辑层接口
 *
 * @author Drury
 * @date 2018/3/19
 */
public interface BiddingResponseService {
    /**
     * 供应商竞价响应接口
     *
     * @param supplierBiddingResponseDto
     * @return
     */
    BaseResponse supplierBiddingResponse(SupplierBiddingResponseDto supplierBiddingResponseDto);

    /**
     * 更新供应商竞价需求响应接口（sku等）
     * 也可用于保存新的竞价需求响应
     *
     * @param jcbdBiddingDemandResponseDto
     * @return
     */
    BaseResponse updateBiddingDemandResponse(JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto);

    /**
     * 供应商竞价状态变更接口
     *
     * @param biddingChangeStateDto
     * @return
     */
    BiddingStateResponseDto supplierBiddingStatusChange(BiddingSupplierChangeStateDto biddingChangeStateDto);

    /**
     * 供应商补录sku接口
     *
     * @param updateSkuDto
     * @return
     */
    BaseResponse updateBiddingDemandResponseSku(UpdateSkuDto updateSkuDto);

    /**
     * 供应商初始状态
     *
     * @param biddingNo
     * @return
     */
    BaseResponse supplierInitStatus(String biddingNo);

    /**
     * 初始化供应商是否修改sku（默认false）
     * @param biddingNo
     * @param supplierId
     * @return
     */
    BaseResponse supplierInitModifySku(String biddingNo, String supplierId);

    /**
     * 放弃响应
     * @param biddingNo
     * @param supplierId
     * @return
     */
    BaseResponse responseGiveUp(String biddingNo, String supplierId);
}
