package bidding.service.service;

import dto.VoteDetailDto;
import dto.VoteQueryResultDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * 竞价投票业务逻辑层接口
 *
 * @author Drury
 * @date 2018/3/19
 */
public interface BiddingVoteService {

    /**
     * 系统随机确认供应商
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse
     */
    BaseResponse randomConfirmSupplier(String biddingCode);


    /**
     * 投票接口
     * @param voteDetailDto
     */
    BaseResponse voteSelectionSupplier(VoteDetailDto voteDetailDto);

    /**
     * 查询的投票详情
     * @param biddingNo
     * @return
     */
    List<VoteQueryResultDto> voteDetailsQuery(String biddingNo);
}
