package bidding.service.service.impl;

import bidding.model.po.JcbdBiddingConformance;
import bidding.model.po.JcbdConformanceCheck;
import bidding.model.po.JcbdProviderConformanceResp;
import bidding.model.repository.JcbdBiddingConformanceRepo;
import bidding.model.repository.JcbdConformanCheckRepo;
import bidding.model.repository.JcbdProviderConformanceRespRepo;
import bidding.model.specification.BiddingConformanceCheckSpecification;
import bidding.service.service.BiddingConformityReviewTransactionalService;
import dto.BiddingConformAuditInfoDTO;
import dto.BiddingConformAuditSupplierDTO;
import dto.BiddingConformityAuditDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;

import java.util.List;
import java.util.UUID;

/**
 * 符合性审查事务层实现
 *
 * @author Drury
 * @date 2018/3/21
 */
@Slf4j
@Service
public class BiddingConformityReviewTransactionalServiceImpl implements BiddingConformityReviewTransactionalService {

    /**
     * 保存符合性审查审核数据
     *
     * @param conformityAudit BiddingConformityAuditDTO
     */

    @Autowired
    JcbdProviderConformanceRespRepo jcbdProviderConformanceRespRepo;

    @Autowired
    JcbdBiddingConformanceRepo jcbdBiddingConformanceRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBiddingConformityReviewAuditData(BiddingConformityAuditDTO conformityAudit) {
        for (BiddingConformAuditSupplierDTO biddingConformAuditSupplier : conformityAudit.getSuppliers()) {
            for (BiddingConformAuditInfoDTO biddingConformAuditInfo : biddingConformAuditSupplier.getAuditInfos()) {
                // 是否修改现有审核结果
                JcbdConformanceCheck conformanceCheck = new JcbdConformanceCheck();
                JcbdBiddingConformance conformance = jcbdBiddingConformanceRepo.findOne(biddingConformAuditInfo.getComplianceId());
                conformanceCheck.setBiddingConformance(conformance);
                conformanceCheck.setProviderId(biddingConformAuditSupplier.getSupplierId());
                JcbdProviderConformanceResp jcbdProviderConformanceResp = jcbdProviderConformanceRespRepo.findOne(biddingConformAuditInfo.getComplianceIdSupplierResponse());
                conformanceCheck.setJcbdProviderConformanceResp(jcbdProviderConformanceResp);
                conformanceCheck.setBiddingGroupMemberId(conformityAudit.getAuditorId());
                conformanceCheck.setEmail(conformityAudit.getEmail());
                List<JcbdConformanceCheck> conformanceChecks = biddingConformanCheckRepo.findAll(new BiddingConformanceCheckSpecification<>(conformanceCheck));
                if(Lang.isEmpty(conformanceChecks)) {
                    // 全新保存审核结果
                    conformanceCheck.setConformanceNo(UUID.randomUUID().toString());
                    JcbdProviderConformanceResp providerConformanceResp = providerConformanceRespRepo.findOne(biddingConformAuditInfo.getComplianceIdSupplierResponse());
                    conformanceCheck.setJcbdProviderConformanceResp(providerConformanceResp);
                } else if(conformanceChecks.size() != 1) {
                    log.error("保存符合性审查审核数据失败 : 找到多条同一审核人同一供应商同一符合性审查项的审核记录");
                    throw new RuntimeException("保存符合性审查审核数据失败 : 找到多条同一审核人同一供应商同一符合性审查项的审核记录");
                } else {
                    conformanceCheck = conformanceChecks.get(0);
                }
                conformanceCheck.setStatus(biddingConformAuditInfo.getAuditStatus());
                biddingConformanCheckRepo.saveAndFlush(conformanceCheck);
            }
        }
    }

    /**
     * 竞价需求符合性审查项供应商响应数据操作对象
     */
    private JcbdProviderConformanceRespRepo providerConformanceRespRepo;

    /**
     * 竞价小组符合性审查数据操作对象
     */
    private JcbdConformanCheckRepo biddingConformanCheckRepo;


    @Autowired
    private void setBiddingConformanCheckRepo(JcbdConformanCheckRepo biddingConformanCheckRepo) {
        this.biddingConformanCheckRepo = biddingConformanCheckRepo;
    }

    @Autowired
    private void setProviderConformanceRespRepo(JcbdProviderConformanceRespRepo providerConformanceRespRepo) {
        this.providerConformanceRespRepo = providerConformanceRespRepo;
    }

}
