package bidding.service.service.impl;

import bidding.model.po.JcbdBidding;
import bidding.model.po.JcbdBiddingOperationLog;
import bidding.model.po.JcbdBiddingPurchaseLog;
import bidding.model.repository.JcbdBiddingOperationLogRepo;
import bidding.model.repository.JcbdBiddingPurchaseLogRepo;
import bidding.model.repository.JcbdBiddingRepo;
import bidding.service.service.BiddingLogService;
import dto.JcbdBiddingOperationLogDto;
import dto.JcbdBiddingPurchaseLogDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 竞价记录业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingLogServiceImpl implements BiddingLogService {

    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;
    @Autowired
    JcbdBiddingPurchaseLogRepo jcbdBiddingPurchaseLogRepo;
    @Autowired
    MapperFacade mapperFacade;

    /**
     * 保存竞价业务操作记录
     * @param biddingOperationLog
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBiddingOperationLog(JcbdBiddingOperationLogDto biddingOperationLog) {
        JcbdBiddingOperationLog operationLog = mapperFacade.map(biddingOperationLog, JcbdBiddingOperationLog.class);
        operationLog.setOperationTime(new Date());
        jcbdBiddingOperationLogRepo.save(operationLog);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBiddingOperationLogs(List<JcbdBiddingOperationLogDto> biddingOperationLogDtoList) {
        List<JcbdBiddingOperationLog> jcbdBiddingOperationLogs = mapperFacade.mapAsList(biddingOperationLogDtoList, JcbdBiddingOperationLog.class);
        jcbdBiddingOperationLogRepo.save(jcbdBiddingOperationLogs);
    }

    @Override
    @Transactional
    public void savePurchaseLog(List<JcbdBiddingPurchaseLogDto> purchaseLogDtos) {
        List<JcbdBiddingPurchaseLog> jcbdBiddingPurchaseLogs = mapperFacade.mapAsList(purchaseLogDtos, JcbdBiddingPurchaseLog.class);
        jcbdBiddingPurchaseLogRepo.save(jcbdBiddingPurchaseLogs);
    }
}
