package bidding.service.service.impl;

import bidding.model.dto.BiddingOrderMangerModelDto;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingOrderManagerSpecification;
import bidding.service.service.query.BiddingOrderManagerService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingOrderMangerDto;
import dto.JcbdRoleOperationDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import query.BiddingOrderManagerListQuery;
import utils.Lang;
import utils.data.BeanMapper;
import utils.jpa.JpaPageUtil;

import java.util.ArrayList;
import java.util.List;

import static definition.BiddingRole.BIDDING_OPERATOR;

/**
 * @author luoxianwei
 * @date 2018/4/14
 * 订单管理业务逻辑层
 */

@Slf4j
@Service
public class BiddingOrderManagerServiceImpl implements BiddingOrderManagerService {

    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;
    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;
    @Autowired
    MapperFacade mapperFacade;

    /**
     * 查询分页获取订单管理列表
     *
     * @param biddingOrderManagerListQuery
     * @return
     */
    @Override
    public Page<BiddingOrderMangerDto> getBiddingOrderMangerList(BiddingOrderManagerListQuery biddingOrderManagerListQuery, Pageable pageable) {
        log.info("获取订单管理列表-请求参数 {}", JSON.toJSONString(biddingOrderManagerListQuery));

        BiddingOrderMangerModelDto biddingOrderMangerModelDto = mapperFacade.map(biddingOrderManagerListQuery, BiddingOrderMangerModelDto.class);
        BiddingOrderManagerSpecification specification = new BiddingOrderManagerSpecification(biddingOrderMangerModelDto);
        Page<JcbdMallOrder> jcbdMallOrders = jcbdMallOrderRepo.findAll(specification, pageable);
        List<JcbdMallOrder> jcbdMallOrderList = jcbdMallOrders.getContent();
        //取出内容，重新封装成满足前台显示的dto
        List<BiddingOrderMangerDto> biddingOrderMangerDtoList = new ArrayList<>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            BiddingOrderMangerDto biddingOrderMangerDto = BeanMapper.map(jcbdMallOrder, BiddingOrderMangerDto.class);
            //竞价编号
            biddingOrderMangerDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());

            //状态
            BiddingOrderStatus biddingOrderStatus = BiddingOrderStatus.biddingOrderStatusMap.get(jcbdMallOrder.getStatus());
            if (!Lang.isEmpty(biddingOrderStatus)) {
                String statusDescription = biddingOrderStatus.getDescription();
                biddingOrderMangerDto.setStatusDescription(statusDescription);
                //操作
                List<JcbdRoleOperationDto> roleOperationDtoList = biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BIDDING_OPERATOR, jcbdMallOrder.getStatus(), StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
                biddingOrderMangerDto.setOperation(roleOperationDtoList);
            } else {
                log.error("订单状态为空");
            }
            biddingOrderMangerDtoList.add(biddingOrderMangerDto);
        }

        return new PageImpl(biddingOrderMangerDtoList, new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    @Override
    public List<BiddingOrderMangerDto> getCancelOrders(BiddingOrderManagerListQuery biddingOrderManagerListQuery) {
        BiddingOrderMangerModelDto biddingOrderMangerModelDto = mapperFacade.map(biddingOrderManagerListQuery, BiddingOrderMangerModelDto.class);
        BiddingOrderManagerSpecification specification = new BiddingOrderManagerSpecification(biddingOrderMangerModelDto);
        List<JcbdMallOrder> jcbdMallOrderList = jcbdMallOrderRepo.findAll(specification);
        return mapperFacade.mapAsList(jcbdMallOrderList,BiddingOrderMangerDto.class);
    }
}
