package bidding.service.service.impl;

import bidding.model.dto.BiddingOrderResultModelDto;
import bidding.model.po.JcbdMallOrder;
import bidding.model.repository.JcbdMallOrderRepo;
import bidding.model.specification.BiddingOrderResultSpecification;
import bidding.service.service.BiddingOrderResultService;
import bidding.service.service.query.BiddingMallOrderQueryService;
import bidding.service.service.query.BiddingOrderQueryService;
import bidding.service.service.query.BiddingQueryService;
import bidding.service.service.query.BiddingRoleOperationQueryService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOrderStatus;
import definition.StatusOperateModule;
import dto.BiddingOrderResultDto;
import dto.JcbdRoleOperationDto;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import query.BiddingOrderResultListQuery;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;

import static definition.BiddingRole.BIDDING_OPERATOR;
/**
* @author luoxianwei
* @date 2018/4/14 
*/
@Slf4j
@Service
public class BiddingOrderResultServiceImpl implements BiddingOrderResultService {

    @Autowired
    JcbdMallOrderRepo jcbdMallOrderRepo;

    /**
     * 分页获取采购结果列表
     * @param biddingOrderResultListQuery
     * @param pageable
     * @return
     */
    @Override
    public Page<BiddingOrderResultDto> getBiddingOrderResultList(BiddingOrderResultListQuery biddingOrderResultListQuery, Pageable pageable) {
        log.info("获取执行结果列表-请求参数 {}", JSON.toJSONString(biddingOrderResultListQuery));

        BiddingOrderResultModelDto biddingOrderResultModelDto = mapperFacade.map(biddingOrderResultListQuery, BiddingOrderResultModelDto.class);
        BiddingOrderResultSpecification specification = new BiddingOrderResultSpecification(biddingOrderResultModelDto);

        Page<JcbdMallOrder> jcbdMallOrders = jcbdMallOrderRepo.findAll(specification, pageable);
        List<JcbdMallOrder> jcbdMallOrderList = jcbdMallOrders.getContent();
        //取出内容，重新封装成满足前台显示的dto
        List<BiddingOrderResultDto> biddingOrderResultDtoList = new ArrayList<>();
        for (JcbdMallOrder jcbdMallOrder : jcbdMallOrderList) {
            BiddingOrderResultDto biddingOrderResultDto = mapperFacade.map(jcbdMallOrder, BiddingOrderResultDto.class);
            //添加执行采购编号
            biddingOrderResultDto.setPurchaseNo(jcbdMallOrder.getJcbdOrder().getPurchaseNo());
            //竞价编号
            biddingOrderResultDto.setBiddingCode(jcbdMallOrder.getJcbdOrder().getJcbdBidding().getBiddingCode());
            //状态
            BiddingOrderStatus biddingOrderStatus = BiddingOrderStatus.biddingOrderStatusMap.get(jcbdMallOrder.getStatus());
            if (!Lang.isEmpty(biddingOrderStatus)){
                String statusDescription = biddingOrderStatus.getDescription();
                biddingOrderResultDto.setStatusDescription(statusDescription);
            }
            biddingOrderResultDto.setStatus(jcbdMallOrder.getStatus());
            //操作
            List<JcbdRoleOperationDto> roleOperationDtoList = biddingRoleOperationQueryService.findByRoleCodeAndStatusAndModuleOrderByShowIndex(BIDDING_OPERATOR,jcbdMallOrder.getStatus(), StatusOperateModule.BIDDING_ORDER_MANAGE.getCode());
            biddingOrderResultDto.setOperation(roleOperationDtoList);

            biddingOrderResultDtoList.add(biddingOrderResultDto);
        }
        return new PageImpl(biddingOrderResultDtoList, new PageRequest(jcbdMallOrders.getNumber(), jcbdMallOrders.getSize(), jcbdMallOrders.getSort()), jcbdMallOrders.getTotalElements());
    }

    @Autowired
    BiddingOrderQueryService biddingOrderQueryService;

    @Autowired
    BiddingMallOrderQueryService biddingMallOrderQueryService;

    @Autowired
    BiddingQueryService biddingQueryService;

    @Autowired
    BiddingRoleOperationQueryService biddingRoleOperationQueryService;


    /**
     * bean 转换工具
     */
    private MapperFacade mapperFacade;

    @Autowired
    private void setMapperFacade(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
    }

}
