package bidding.service.service.impl;

import bidding.model.po.*;
import bidding.model.repository.*;
import bidding.service.service.BiddingMainService;
import bidding.service.service.BiddingResponseService;
import com.alibaba.fastjson.JSON;
import definition.BiddingOperateCode;
import definition.BiddingStatus;
import definition.ProviderConformanceRespStatus;
import dto.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 竞价响应业务逻辑层
 *
 * @author Drury
 * @date 2018/3/19
 */
@Slf4j
@Service
public class BiddingResponseServiceImpl implements BiddingResponseService {

    @Autowired
    JcbdBiddingRepo jcbdBiddingRepo;

    @Autowired
    JcbdBdProviderRepo jcbdBdProviderRepo;

    @Autowired
    JcbdBiddingDemandRepo jcbdBiddingDemandRepo;

    @Autowired
    JcbdBiddingDemandRespRepo jcbdBiddingDemandRespRepo;

    @Autowired
    MallAttachmentRepo mallAttachmentRepo;

    @Autowired
    JcbdStoreContactsRepo jcbdStoreContactsRepo;
    @Autowired
    BiddingMainService biddingMainService;
    @Autowired
    BiddingStatusCategoryRepo biddingStatusCategoryRepo;

    @Autowired
    JcbdBiddingOperationLogRepo jcbdBiddingOperationLogRepo;

    private static final String FUHE = "1";
    private static final String UNFUHE = "0";

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse supplierBiddingResponse(SupplierBiddingResponseDto supplierBiddingResponseDto) {
        String biddingNo = supplierBiddingResponseDto.getJcbdBiddingNo();
        boolean isAllAccored = true;
        log.info("竞价编号：{}", biddingNo);
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(supplierBiddingResponseDto.getJcbdBiddingNo(), false);
        if (jcbdBidding != null) {
            List<JcbdBdProvider> jcbdBdProviders = jcbdBidding.getJcbdBdProviders();
            for (JcbdBdProvider jcbdBdProvider : jcbdBdProviders) {
                if (jcbdBdProvider.getProviderId().equals(supplierBiddingResponseDto.getProviderId())) {
                    List<JcbdBiddingDemand> jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
                    for (JcbdBiddingDemand demand : jcbdBiddingDemands) {
                        List<JcbdBiddingDemandResponse> jcbdBiddingDemandResponses = demand.getJcbdBiddingDemandResponses();
                        for (JcbdBiddingDemandResponse response : jcbdBiddingDemandResponses) {
                            if(response.getResponseProviderId().equals(jcbdBdProvider.getId())) {
                                if (!ProviderConformanceRespStatus.ACCORD.getValue().equals(response.getIsAllAccord())) {
                                    isAllAccored = false;
                                }
                                if (response.getResponseProviderId().equals(jcbdBdProvider.getId())) {
                                    response.setQouteIndate(supplierBiddingResponseDto.getOfferValidity());
                                    jcbdBiddingDemandRespRepo.save(response);
                                }
                            }
                        }
                    }
                    if (isAllAccored) {
                        jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_YES.getValue());
                        jcbdBdProvider.setOfferValidity(supplierBiddingResponseDto.getOfferValidity());
                        jcbdBdProvider.setResponseStatus(ProviderConformanceRespStatus.ACCORD.getValue());
                        jcbdBdProviderRepo.save(jcbdBdProvider);
                    } else {
                        jcbdBdProvider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_YES_GIVEUP.getValue());
                        jcbdBdProvider.setOfferValidity(supplierBiddingResponseDto.getOfferValidity());
                        jcbdBdProvider.setResponseStatus(ProviderConformanceRespStatus.ACCORD.getValue());
                        jcbdBdProviderRepo.save(jcbdBdProvider);
                    }
                }
            }
            return new BaseResponse(true, "提交成功");
        } else {
            return new BaseResponse("找不到对应的竞价");
        }

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public BaseResponse updateBiddingDemandResponse(JcbdBiddingDemandResponseDto jcbdBiddingDemandResponseDto) {
        String biddingId = jcbdBiddingDemandResponseDto.getJcbdBiddingDemand().getBiddingId();
        String storeId = jcbdBiddingDemandResponseDto.getStoreId();
        JcbdBdProvider jcbdBdProvider = jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(biddingId, storeId, false);
        if (jcbdBdProvider != null) {
            jcbdBiddingDemandResponseDto.setResponseProviderId(jcbdBdProvider.getId());
        }
//
        String demandCode = jcbdBiddingDemandResponseDto.getJcbdBiddingDemand().getDemandCode();
        JcbdBiddingDemand jcbdBiddingDemand = jcbdBiddingDemandRepo.findByDemandCodeAndJcbdBiddingIdAndIsDelete(demandCode, biddingId, false);
//        List<JcbdBiddingDemandResponse> jcbdBiddingDemandResponses = jcbdBiddingDemand.getJcbdBiddingDemandResponses();
//        for (JcbdBiddingDemandResponse jcbdBiddingDemandResponse : jcbdBiddingDemandResponses) {
//            if (jcbdBiddingDemandResponse.getResponseProviderId().equals(jcbdBiddingDemandResponseDto.getResponseProviderId())) {
//                jcbdBiddingDemandRespRepo.delete(jcbdBiddingDemandResponse.getId());
//            }
//        }
        String id = jcbdBiddingDemandResponseDto.getId();
        if (!Lang.isEmpty(id)) {
            JcbdBiddingDemandResponse demandResponse = jcbdBiddingDemandRespRepo.findOne(id);
            jcbdBiddingDemandRespRepo.delete(demandResponse);
        }

        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = BeanMapper.map(jcbdBiddingDemandResponseDto, JcbdBiddingDemandResponse.class);
        jcbdBiddingDemandResponse.setId(null);
        List<JcbdProviderConformanceResp> providerConformanceResps = jcbdBiddingDemandResponse.getJcbdProviderConformanceResps();
        for (JcbdProviderConformanceResp jcbdProviderConformanceResp : providerConformanceResps) {
            jcbdProviderConformanceResp.setJcbdBiddingDemandResponse(jcbdBiddingDemandResponse);
        }
        jcbdBiddingDemandResponse.setJcbdProviderConformanceResps(providerConformanceResps);

        List<JcbdProviderAddressResponse> providerAddressResponses = jcbdBiddingDemandResponse.getJcbdProviderAddressResponses();
        for (JcbdProviderAddressResponse jcbdProviderAddressResponse : providerAddressResponses) {
            jcbdProviderAddressResponse.setJcbdBiddingDemandResponse(jcbdBiddingDemandResponse);
        }
        jcbdBiddingDemandResponse.setJcbdProviderAddressResponses(providerAddressResponses);


        List<JcbdProviderAddressResponse> jcbdProviderAddressResponses = jcbdBiddingDemandResponse.getJcbdProviderAddressResponses();
        for (JcbdProviderAddressResponse jcbdProviderAddressResponse : jcbdProviderAddressResponses) {
            if (FUHE.equals(jcbdProviderAddressResponse.getStatus())) {
                jcbdBiddingDemandResponse.setIsAllAccord(FUHE);
            } else {
                jcbdBiddingDemandResponse.setIsAllAccord(UNFUHE);
                break;
            }
        }
        if (FUHE.equals(jcbdBiddingDemandResponse.getIsAllAccord())) {
            List<JcbdProviderConformanceResp> jcbdProviderConformanceResps = jcbdBiddingDemandResponse.getJcbdProviderConformanceResps();
            for (JcbdProviderConformanceResp jcbdProviderConformanceResp : jcbdProviderConformanceResps) {
                if (FUHE.equals(jcbdProviderConformanceResp.getStatus())) {
                    jcbdBiddingDemandResponse.setIsAllAccord(FUHE);
                } else {
                    jcbdBiddingDemandResponse.setIsAllAccord(UNFUHE);
                    break;
                }
            }
        }
        jcbdBiddingDemandResponse.setJcbdBiddingDemand(jcbdBiddingDemand);
        JcbdBiddingDemandResponse demandResponse = jcbdBiddingDemandRespRepo.saveAndFlush(jcbdBiddingDemandResponse);

        List<MallAttachment> mallAttachmentList = mallAttachmentRepo.findByAttachmentCorrelationAndIsDelete(demandResponse.getId(), false);
        if (!Lang.isEmpty(mallAttachmentList)) {
            for (MallAttachment mallAttachment : mallAttachmentList) {
                mallAttachmentRepo.delete(mallAttachment);
            }
        }
        List<MallAttachmentDto> attachmentDtos = jcbdBiddingDemandResponseDto.getAttachment();
        if (!Lang.isEmpty(attachmentDtos)) {
            for (MallAttachmentDto mallAttachmentDto : attachmentDtos) {
                MallAttachment mallAttachment = BeanMapper.map(mallAttachmentDto, MallAttachment.class);
                mallAttachment.setAttachmentCorrelation(jcbdBiddingDemandResponse.getId());
                mallAttachmentRepo.save(mallAttachment);
            }
        }
        return new BaseResponse(true, "保存成功");
    }


    @Override
    public BiddingStateResponseDto supplierBiddingStatusChange(BiddingSupplierChangeStateDto changeStateDto) {
        JcbdBdProvider provider = null;

        try {
            if (StringUtils.isEmpty(changeStateDto.getBiddingNo()) || StringUtils.isEmpty(changeStateDto.getOpcode()) || StringUtils.isEmpty(changeStateDto.getSupplierId())) {
                throw new IllegalArgumentException("更新供应商竞价状态参数不正确");
            }
            String biddingNo = changeStateDto.getBiddingNo();
            JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
            provider = jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), changeStateDto.getSupplierId(), false);
            if (provider == null) {
                throw new IllegalArgumentException("没有该供应商");
            }
            if (!StringUtils.equals(changeStateDto.getCurrentState(), provider.getStatus())) {
                throw new IllegalArgumentException("供应商当前状态不正确");
            }
            BiddingStatusTransform biddingStatusTransform = null;
            String statusCategoryCode = BiddingMainService.BIDDING_STATUS_CATEGORY_SUPPLIER;
            BiddingStatusCategory biddingStatusCategory = biddingStatusCategoryRepo.findByBiddingCategoryCode(statusCategoryCode);
            biddingStatusTransform = biddingMainService.getBiddingStatusTransform(changeStateDto, biddingStatusCategory);
            provider.setStatus(biddingStatusTransform.getNextStatus());
            jcbdBdProviderRepo.saveAndFlush(provider);
        } catch (Exception e) {
            log.error("竞价状态转换参数错误,changeStateDto={}", JSON.toJSONString(changeStateDto), e);
            return new BiddingStateResponseDto(false, e.getMessage());
        }
        return new BiddingStateResponseDto(true, "操作成功", provider.getStatus());
    }

    @Override
    public BaseResponse updateBiddingDemandResponseSku(UpdateSkuDto updateSkuDto) {
        String demandNo = updateSkuDto.getDemandNo();
        String biddingNo = updateSkuDto.getBiddingNo();
        String providerId = updateSkuDto.getProviderId();
        JcbdBidding bidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        JcbdBdProvider jcbdBdProvider = jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(bidding.getId(), providerId, false);
        JcbdBiddingDemand demand = jcbdBiddingDemandRepo.findByDemandCodeAndJcbdBiddingIdAndIsDelete(demandNo, bidding.getId(), false);
        JcbdBiddingDemandResponse jcbdBiddingDemandResponse = jcbdBiddingDemandRespRepo.findByJcbdBiddingDemandIdAndResponseProviderIdAndIsDelete(demand.getId(), jcbdBdProvider.getId(), false);
        if(Lang.isEmpty(jcbdBiddingDemandResponse.getSkuModify())||!jcbdBiddingDemandResponse.getSkuModify()){
            if (!updateSkuDto.getSku().equals(jcbdBiddingDemandResponse.getSku())){
                    jcbdBiddingDemandResponse.setSkuModify(true);
                    jcbdBiddingDemandResponse.setSkuIsModify(true);
            }
        }
        JcbdBiddingOperationLog jcbdBiddingOperationLog=new JcbdBiddingOperationLog();
        if(jcbdBiddingDemandResponse.getSku()==null){
            jcbdBiddingOperationLog.setOperationContent("新增商品编码");
            jcbdBiddingOperationLog.setRemark("需求"+demandNo+"补录商品编码为"+updateSkuDto.getSku());
        }else {
            jcbdBiddingOperationLog.setOperationContent("修改商品编码");
            jcbdBiddingOperationLog.setRemark("需求"+demandNo+"将旧的商品编码"+jcbdBiddingDemandResponse.getSku()+"修改为新的商品编码"+updateSkuDto.getSku());
        }
        jcbdBiddingDemandResponse.setSku(updateSkuDto.getSku());
        jcbdBiddingDemandResponse.setGoodsLink(updateSkuDto.getUrl());

        jcbdBiddingDemandRespRepo.save(jcbdBiddingDemandResponse);


        jcbdBiddingOperationLog.setOperatorName(updateSkuDto.getOperatorName());
        jcbdBiddingOperationLog.setOperationTime(new Date());
        jcbdBiddingOperationLog.setBiddingId(bidding.getId());
        jcbdBiddingOperationLogRepo.save(jcbdBiddingOperationLog);
        return new BaseResponse(true, "更新sku成功");
    }

    @Transactional
    @Override
    public BaseResponse supplierInitStatus(String biddingNo) {
        JcbdBidding bidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (bidding == null) {
            return new BaseResponse(false, "竞价不存在");
        }
        List<JcbdBdProvider> providers = bidding.getJcbdBdProviders();
        for (JcbdBdProvider provider : providers) {
            BiddingSupplierChangeStateDto biddingChangeStateDto = new BiddingSupplierChangeStateDto();
            biddingChangeStateDto.setOpcode(BiddingOperateCode.SUPPLIER_INIT.getCode());
            biddingChangeStateDto.setBiddingNo(biddingNo);
            biddingChangeStateDto.setSupplierId(provider.getProviderId());
            BiddingStateResponseDto biddingStateResponseDto = supplierBiddingStatusChange(biddingChangeStateDto);
            if (!biddingStateResponseDto.isSuccess() || !StringUtils.equals(BiddingStatus.SUPPLIER_RESPONSE_NOT.getValue(), biddingStateResponseDto.getBiddingState())) {
                log.error("初始化供应商竞价错误,biddingNo={},biddingStateResponseDto={}", biddingNo, JSON.toJSONString(biddingStateResponseDto));
                throw new RuntimeException("初始化供应商竞价错误");
            }else {
                provider.setPublish(true);
            }
        }
        try{
            jcbdBdProviderRepo.save(providers);
        }catch (Exception e){
            log.error("初始化供应商竞价数据库操作错误,biddingNo={},biddingStateResponseDto={}",e);
            throw new RuntimeException("初始化供应商竞价错误");
        }
        return new BaseResponse(true, "初始化供应商状态成功");
    }

    @Override
    @Transactional
    public BaseResponse supplierInitModifySku(String biddingNo, String supplierId) {
        if (Lang.isEmpty(biddingNo)||Lang.isEmpty(supplierId)){
            log.error("初始化供应商是否修改sku参数传入错误");
            return new BaseResponse("参数传入错误");
        }
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty(jcbdBidding)){
            log.error("初始化供应商是否修改sku  无编号为{}的竞价",biddingNo);
            return new BaseResponse("无此竞价");
        }
        JcbdBdProvider provider = jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, false);
        if (Lang.isEmpty(provider)){
            log.error("初始化供应商是否修改sku  无供应商id为{}的供应商",supplierId);
            return new BaseResponse("无此供应商");
        }
        List<JcbdBiddingDemand> jcbdBiddingDemands = jcbdBidding.getJcbdBiddingDemands();
        if(Lang.isEmpty(jcbdBiddingDemands)){
            log.error("初始化供应商是否修改sku  编号为{}的竞价下无需求",biddingNo);
            return new BaseResponse("该竞价下无需求");
        }
        List<JcbdBiddingDemandResponse> responses = new ArrayList<>();
        jcbdBiddingDemands.forEach(demand ->{
            demand.getJcbdBiddingDemandResponses().forEach(response ->{
                if (response.getResponseProviderId().equals(provider.getId())){
                    response.setSkuModify(false);
                    responses.add(response);
                }
            });
        });
        try {
            jcbdBiddingDemandRespRepo.save(responses);
        }catch (Exception e){
            log.error("初始化供应商是否修改sku 编号为{}供应商id为{}数据库操作有误", biddingNo, supplierId, e);
            return new BaseResponse("数据库操作有误");
        }
        return new BaseResponse(true);
    }

    @Override
    public BaseResponse responseGiveUp(String biddingNo, String supplierId) {
        if (Lang.isEmpty(biddingNo)||Lang.isEmpty(supplierId)){
            log.error("放弃响应参数传入错误");
            return new BaseResponse("参数传入错误");
        }
        JcbdBidding jcbdBidding = jcbdBiddingRepo.findByBiddingCodeAndIsDelete(biddingNo, false);
        if (Lang.isEmpty(jcbdBidding)){
            log.error("放弃响应  无编号为{}的竞价",biddingNo);
            return new BaseResponse("无此竞价");
        }
        JcbdBdProvider provider = jcbdBdProviderRepo.findByJcbdBiddingIdAndProviderIdAndIsDelete(jcbdBidding.getId(), supplierId, false);
        if (Lang.isEmpty(provider)){
            log.error("放弃响应  无供应商id为{}的供应商",supplierId);
            return new BaseResponse("无此供应商");
        }
        provider.setStatus(BiddingStatus.SUPPLIER_RESPONSE_GIVEUP.getValue());
        provider.setResponseStatus(ProviderConformanceRespStatus.NOT_ACCORD.getValue());
        try {
            jcbdBdProviderRepo.save(provider);
        }catch (Exception e){
            log.error("放弃响应 编号为{}供应商id为{}数据库操作有误", biddingNo, supplierId, e);
            return new BaseResponse("数据库操作有误");
        }
        return new BaseResponse(true);
    }
}
